/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.table;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pl.mjaron.etudes.Obj;
import pl.mjaron.etudes.Str;
import pl.mjaron.etudes.table.ITableSource;

public class BeanTableSource<BeanT>
implements ITableSource {
    private final Class<BeanT> tClass;
    private final Iterable<BeanT> values;
    private final Field[] tFields;
    private final List<String> headers;

    public BeanTableSource(Iterable<BeanT> values, Class<BeanT> tClass) {
        this.tClass = tClass;
        this.values = values;
        this.tFields = Obj.getFields(this.tClass);
        this.headers = Obj.getFieldNames(this.tFields);
    }

    @Override
    public int getColumnsCount() {
        return this.tFields.length;
    }

    @Override
    public Iterable<String> getHeaders() {
        return this.headers;
    }

    @Override
    public Iterator<Iterable<String>> iterator() {
        return new RowsIterator<BeanT>(this.tClass, this.tFields, this.values);
    }

    private static class RowsIterator<BeanT>
    implements Iterator<Iterable<String>> {
        final Iterator<BeanT> beanIterator;
        private final Class<BeanT> tClass;
        private final Field[] tFields;

        public RowsIterator(Class<BeanT> tClass, Field[] tFields, Iterable<BeanT> values) {
            this.tClass = tClass;
            this.tFields = tFields;
            this.beanIterator = values.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.beanIterator.hasNext();
        }

        @Override
        public Iterable<String> next() {
            BeanT bean = this.beanIterator.next();
            ArrayList<String> stringSeries = new ArrayList<String>(this.tFields.length);
            Obj.visitFieldValues(bean, this.tClass, this.tFields, (name, value) -> stringSeries.add(Str.orEmpty(value)));
            return stringSeries;
        }
    }
}

