/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.table;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import pl.mjaron.etudes.Arr;
import pl.mjaron.etudes.table.AlignmentMode;
import pl.mjaron.etudes.table.RenderRuntime;
import pl.mjaron.etudes.table.TableColumnsWidthDetector;

public class ColumnWidthResolver {
    private AlignmentMode mode = AlignmentMode.DEFAULT;
    private int[] widths = null;

    public void configure(AlignmentMode mode, int[] widths) {
        if (mode == AlignmentMode.ARBITRARY) {
            if (widths == null) {
                throw new IllegalArgumentException("When setting " + AlignmentMode.class.getSimpleName() + " to " + (Object)((Object)mode) + ", column widths must be specified.");
            }
        } else if ((mode == AlignmentMode.ALIGNED || mode == AlignmentMode.EQUAL) && widths != null) {
            throw new IllegalArgumentException("When setting " + AlignmentMode.class.getSimpleName() + " to " + (Object)((Object)mode) + ", column widths mustn't be specified. It will be computed during resolving stage.");
        }
        this.mode = mode;
        this.widths = widths;
    }

    public void configure(AlignmentMode mode) {
        this.configure(mode, null);
    }

    public void resolve(@NotNull RenderRuntime runtime) {
        if (this.mode == AlignmentMode.DEFAULT) {
            this.mode = runtime.getWriter().getDefaultAlignedColumnWidths() ? AlignmentMode.ALIGNED : AlignmentMode.NOT_ALIGNED;
        }
        if (this.mode == AlignmentMode.ALIGNED) {
            this.widths = TableColumnsWidthDetector.compute(runtime.getSource(), runtime.getEscaper());
        } else if (this.mode == AlignmentMode.EQUAL) {
            this.widths = TableColumnsWidthDetector.compute(runtime.getSource(), runtime.getEscaper());
            int maxWidth = Arr.max(this.widths);
            Arrays.fill(this.widths, maxWidth);
        }
    }

    public boolean hasWidths() {
        return this.widths != null;
    }

    public int[] getWidths() {
        return this.widths;
    }

    public int getWidth(int index) {
        return this.widths[index];
    }
}

