/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.table;

import org.jetbrains.annotations.Contract;
import pl.mjaron.etudes.Str;
import pl.mjaron.etudes.table.IEscaper;
import pl.mjaron.etudes.table.RenderRuntime;

public class CsvEscaper
implements IEscaper {
    private String delimiter = ",";
    private String lineBreak = "\r\n";

    public boolean needsEscape(String what) {
        return Str.contains(what, '\r') || Str.contains(what, '\n') || what.contains(this.delimiter) || what.contains("\"") || what.contains(this.lineBreak);
    }

    @Contract(pure=true)
    public String doEscape(String what) {
        return "\"" + what.replace("\"", "\"\"") + "\"";
    }

    @Override
    public void beginTable(RenderRuntime runtime) {
        if (runtime.getCellDelimiter() != null) {
            this.delimiter = runtime.getCellDelimiter();
        }
        if (runtime.getLineBreak() != null) {
            this.lineBreak = runtime.getLineBreak();
        }
    }

    @Override
    @Contract(pure=true)
    public String escape(String what) {
        if (this.needsEscape(what)) {
            return this.doEscape(what);
        }
        return what;
    }
}

