/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.table;

import pl.mjaron.etudes.Str;
import pl.mjaron.etudes.table.IEscaper;

public class HtmlEscaper
implements IEscaper {
    private static final char[] ESCAPED_CHARS = new char[]{'&', '<', '>', '\"', '\'', '\r', '\n'};

    public boolean needsEscape(String what) {
        return Str.contains(what, ESCAPED_CHARS);
    }

    @Override
    public String escape(String what) {
        if (!this.needsEscape(what)) {
            return what;
        }
        StringBuilder str = new StringBuilder(what.length() + 16);
        char prev = '\u0000';
        for (int i = 0; i < what.length(); ++i) {
            char ch = what.charAt(i);
            if (ch == '&') {
                str.append("&amp");
            } else if (ch == '<') {
                str.append("&lt");
            } else if (ch == '>') {
                str.append("&gt");
            } else if (ch == '\"') {
                str.append("&quot");
            } else if (ch == '\'') {
                str.append("&#39");
            } else if (ch == '\r') {
                str.append("<br/>");
            } else if (ch == '\n') {
                if (prev != '\r') {
                    str.append("<br/>");
                }
            } else {
                str.append(ch);
            }
            prev = ch;
        }
        return str.toString();
    }
}

