/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.table;

import pl.mjaron.etudes.table.HtmlOptions;
import pl.mjaron.etudes.table.ITableWriter;
import pl.mjaron.etudes.table.RenderRuntime;
import pl.mjaron.etudes.table.VerticalAlign;

public class HtmlTableWriter
implements ITableWriter {
    private RenderRuntime runtime = null;
    private final String indentationUnit = "    ";
    private final HtmlOptions htmlOptions;

    public HtmlTableWriter(HtmlOptions htmlOptions) {
        this.htmlOptions = htmlOptions;
    }

    public HtmlTableWriter() {
        this(new HtmlOptions());
    }

    @Override
    public void beginTable(RenderRuntime runtime) {
        this.runtime = runtime;
        runtime.append("<table");
        if (this.htmlOptions.getTableId() != null) {
            runtime.append(" id=\"");
            runtime.append(this.htmlOptions.getTableId());
            runtime.append('\"');
        }
        if (this.htmlOptions.getTableClass() != null) {
            runtime.append(" class=\"");
            runtime.append(this.htmlOptions.getTableClass());
            runtime.append('\"');
        }
        runtime.appendLine('>');
    }

    @Override
    public void endTable() {
        this.runtime.appendLine("</table>");
        this.runtime = null;
    }

    @Override
    public void beginHeader() {
        this.runtime.append("    ");
        this.runtime.appendLine("<tr>");
    }

    @Override
    public void endHeader() {
        this.runtime.append("    ");
        this.runtime.appendLine("</tr>");
    }

    @Override
    public void beginRow() {
        this.runtime.append("    ");
        this.runtime.appendLine("<tr>");
    }

    @Override
    public void endRow() {
        this.runtime.append("    ");
        this.runtime.appendLine("</tr>");
    }

    public void writeColumnStyle() {
        VerticalAlign verticalAlign = this.runtime.getCurrentColumnVerticalAlign();
        if (verticalAlign == null) {
            return;
        }
        switch (verticalAlign) {
            case Left: {
                this.runtime.append(" style=\"text-align: left;\"");
                return;
            }
            case Right: {
                this.runtime.append(" style=\"text-align: right;\"");
                return;
            }
            case Center: {
                this.runtime.append(" style=\"text-align: center;\"");
                return;
            }
        }
        throw new RuntimeException("Unexpected vertical align value: " + (Object)((Object)verticalAlign));
    }

    @Override
    public void writeCell(String what) {
        this.runtime.append("    ");
        this.runtime.append("    ");
        if (this.runtime.isHeaderState()) {
            this.runtime.append("<th");
            this.writeColumnStyle();
            this.runtime.append(">");
            this.runtime.append(what);
            this.runtime.append("</th>");
        } else {
            this.runtime.append("<td");
            this.writeColumnStyle();
            this.runtime.append(">");
            this.runtime.append(what);
            this.runtime.append("</td>");
        }
        this.runtime.appendLine();
    }
}

