/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.table;

import java.util.ArrayList;
import java.util.Iterator;
import pl.mjaron.etudes.IRandomIterator;
import pl.mjaron.etudes.table.ITableSource;
import pl.mjaron.etudes.table.ManipulatingTableSourceIterator;

public class ManipulatingTableSource
implements ITableSource {
    private final ITableSource underlyingSource;
    private final ArrayList<Integer> columnOrder;
    private final ArrayList<String> columnNames;
    final IRandomIterator<String> headers;

    public ManipulatingTableSource(ITableSource underlyingSource, ArrayList<Integer> columnOrder, ArrayList<String> columnNames) {
        this.underlyingSource = underlyingSource;
        this.columnOrder = columnOrder;
        this.columnNames = columnNames;
        this.headers = IRandomIterator.from(underlyingSource.getHeaders());
    }

    @Override
    public int getColumnsCount() {
        return this.columnOrder.size();
    }

    @Override
    public Iterable<String> getHeaders() {
        return this.columnNames;
    }

    @Override
    public Iterator<Iterable<String>> iterator() {
        return new ManipulatingTableSourceIterator(this.underlyingSource, this.columnOrder);
    }

    @Override
    public boolean hasHeaders() {
        return this.underlyingSource.hasHeaders();
    }
}

