/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.table;

import java.util.ArrayList;
import java.util.List;
import pl.mjaron.etudes.Container;
import pl.mjaron.etudes.IRandomIterator;
import pl.mjaron.etudes.Pair;
import pl.mjaron.etudes.Str;
import pl.mjaron.etudes.table.ColumnSelector;
import pl.mjaron.etudes.table.IColumnNameGenerator;
import pl.mjaron.etudes.table.ITableSource;
import pl.mjaron.etudes.table.ManipulatingTableSource;

public class ManipulatingTableSourceBuilder {
    private final List<ColumnEntry> finalColumns = new ArrayList<ColumnEntry>();
    private ITableSource underlyingSource;
    private ColumnSelector columnSelector;
    private IRandomIterator<String> headers = null;
    private boolean allColumns = true;

    public ITableSource getUnderlyingSource() {
        return this.underlyingSource;
    }

    public ManipulatingTableSourceBuilder setUnderlyingSource(ITableSource underlyingSource) {
        this.underlyingSource = underlyingSource;
        if (underlyingSource.hasHeaders()) {
            this.headers = IRandomIterator.from(underlyingSource.getHeaders());
        }
        return this;
    }

    public ManipulatingTableSourceBuilder setColumnSelector(ColumnSelector columnSelector) {
        this.columnSelector = columnSelector;
        return this;
    }

    public void setAllColumns(boolean allColumns) {
        this.allColumns = allColumns;
    }

    public void selectColumns() {
        for (Pair<String, String> entry : this.columnSelector.getEntries()) {
            this.headers.setFloorPosition();
            IRandomIterator<String> entryIt = Container.find(this.headers, entry.getKey());
            if (entryIt == null) {
                throw new IllegalArgumentException("Cannot resolve column name for requested column: [" + entry + "]: Given column name not found. All column identifiers: " + Str.join(this.underlyingSource.getHeaders(), ", "));
            }
            ColumnEntry columnEntry = new ColumnEntry();
            columnEntry.sourceColumnIndex = entryIt.getPosition();
            columnEntry.sourceColumnName = (String)entryIt.getCurrent();
            columnEntry.columnNameAlias = entry.getValue();
            this.finalColumns.add(columnEntry);
        }
    }

    public void selectAllColumns() {
        this.headers.setFloorPosition();
        while (this.headers.hasNext()) {
            ColumnEntry columnEntry = new ColumnEntry();
            columnEntry.sourceColumnName = (String)this.headers.next();
            columnEntry.sourceColumnIndex = this.headers.getPosition();
            columnEntry.columnNameAlias = this.columnSelector.getColumnAlias(columnEntry.sourceColumnName);
            this.finalColumns.add(columnEntry);
        }
    }

    public void determineMissingColumnNameAliases() {
        for (ColumnEntry columnEntry : this.finalColumns) {
            if (columnEntry.columnNameAlias != null) continue;
            columnEntry.columnNameAlias = columnEntry.sourceColumnName;
        }
    }

    public void determineColumnNameAliases(IColumnNameGenerator generator) {
        for (int i = 0; i < this.finalColumns.size(); ++i) {
            ColumnEntry columnEntry = this.finalColumns.get(i);
            columnEntry.columnNameAlias = generator.getColumnName(columnEntry.sourceColumnIndex, columnEntry.sourceColumnName, i);
        }
    }

    public void determineMissingColumnNameAliases(IColumnNameGenerator generator) {
        for (int i = 0; i < this.finalColumns.size(); ++i) {
            ColumnEntry columnEntry = this.finalColumns.get(i);
            if (columnEntry.columnNameAlias != null) continue;
            columnEntry.columnNameAlias = generator.getColumnName(columnEntry.sourceColumnIndex, columnEntry.sourceColumnName, i);
        }
    }

    public ITableSource build() {
        if (this.finalColumns.isEmpty() && this.columnSelector == null) {
            return this.underlyingSource;
        }
        if (this.allColumns) {
            this.selectAllColumns();
        } else {
            this.selectColumns();
        }
        this.determineMissingColumnNameAliases();
        ArrayList<Integer> columnOrder = new ArrayList<Integer>(this.finalColumns.size());
        ArrayList<String> columnNames = new ArrayList<String>(this.finalColumns.size());
        for (ColumnEntry columnEntry : this.finalColumns) {
            columnOrder.add(columnEntry.sourceColumnIndex);
            columnNames.add(columnEntry.columnNameAlias);
        }
        return new ManipulatingTableSource(this.underlyingSource, columnOrder, columnNames);
    }

    public static class ColumnEntry {
        int sourceColumnIndex = -1;
        String sourceColumnName = null;
        String columnNameAlias = null;
    }
}

