/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.table;

import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import pl.mjaron.etudes.IRandomIterator;

class ManipulatingTableSourceRow
implements Iterable<String> {
    private final ArrayList<Integer> columnOrder;
    private final IRandomIterator<String> underlyingRowRandomIterator;

    public ManipulatingTableSourceRow(ArrayList<Integer> columnOrder, Iterable<String> underlyingRow) {
        this.columnOrder = columnOrder;
        this.underlyingRowRandomIterator = IRandomIterator.from(underlyingRow);
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int currentColumnIndex = -1;

            @Override
            public boolean hasNext() {
                return this.currentColumnIndex + 1 < ManipulatingTableSourceRow.this.columnOrder.size();
            }

            @Override
            public String next() {
                ++this.currentColumnIndex;
                ManipulatingTableSourceRow.this.underlyingRowRandomIterator.setPosition((Integer)ManipulatingTableSourceRow.this.columnOrder.get(this.currentColumnIndex));
                return (String)ManipulatingTableSourceRow.this.underlyingRowRandomIterator.getCurrent();
            }
        };
    }
}

