/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.table;

import pl.mjaron.etudes.Arr;
import pl.mjaron.etudes.table.IEscaper;

public class MarkdownEscaper
implements IEscaper {
    public static final char[] DEFAULT_ESCAPED_CHARS = new char[]{'_', '*', '[', ']', '(', ')', '~', '`', '>', '#', '+', '-', '=', '|', '{', '}', '.', '!'};
    private char[] escaped = DEFAULT_ESCAPED_CHARS;
    private static final MarkdownEscaper DEFAULT_INSTANCE = new MarkdownEscaper();

    public MarkdownEscaper() {
    }

    public MarkdownEscaper(char[] escaped) {
        this.escaped = escaped;
        if (escaped == null) {
            throw new NullPointerException("Escaped chars must be initialized, got null.");
        }
    }

    @Override
    public String escape(String what) {
        StringBuilder out = new StringBuilder(what.length());
        for (int i = 0; i < what.length(); ++i) {
            char ch = what.charAt(i);
            if (Arr.contains(this.escaped, ch)) {
                out.append("&#");
                out.append((int)what.charAt(i));
                out.append(';');
                continue;
            }
            out.append(what.charAt(i));
        }
        return out.toString();
    }

    public static MarkdownEscaper getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }
}

