/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.table;

import pl.mjaron.etudes.Pair;
import pl.mjaron.etudes.Str;
import pl.mjaron.etudes.table.ITableWriter;
import pl.mjaron.etudes.table.RenderRuntime;
import pl.mjaron.etudes.table.VerticalAlign;

public class MarkdownTableWriter
implements ITableWriter {
    RenderRuntime runtime = null;

    @Override
    public boolean getDefaultAlignedColumnWidths() {
        return true;
    }

    @Override
    public void beginTable(RenderRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public void endTable() {
    }

    @Override
    public void beginHeader() {
    }

    public Pair<String, String> determineColumnDividerMargins(int columnIdx) {
        VerticalAlign verticalAlign = this.runtime.getVerticalAlign(columnIdx);
        if (verticalAlign == null) {
            return new Pair<String, String>("-", "-");
        }
        if (verticalAlign == VerticalAlign.Left) {
            return new Pair<String, String>(":", "-");
        }
        if (verticalAlign == VerticalAlign.Right) {
            return new Pair<String, String>("-", ":");
        }
        if (verticalAlign == VerticalAlign.Center) {
            return new Pair<String, String>(":", ":");
        }
        throw new RuntimeException("Unsupported " + VerticalAlign.class.getSimpleName() + " value: " + (Object)((Object)verticalAlign));
    }

    @Override
    public void endHeader() {
        this.runtime.append("|");
        this.runtime.appendLine();
        if (this.runtime.hasColumnWidths()) {
            for (int i = 0; i < this.runtime.getColumnsCount(); ++i) {
                int w = this.runtime.getColumnWidth(i);
                Pair<String, String> margins = this.determineColumnDividerMargins(i);
                this.runtime.append("|");
                this.runtime.append(margins.getKey());
                Str.pad(this.runtime.getOut(), w, '-');
                this.runtime.append(margins.getValue());
            }
        } else {
            for (int i = 0; i < this.runtime.getColumnsCount(); ++i) {
                Pair<String, String> margins = this.determineColumnDividerMargins(i);
                this.runtime.append("|");
                this.runtime.append(margins.getKey());
                this.runtime.append("----");
                this.runtime.append(margins.getValue());
            }
        }
        this.runtime.appendLine("|");
    }

    @Override
    public void beginRow() {
    }

    @Override
    public void endRow() {
        this.runtime.appendLine("|");
    }

    @Override
    public void writeCell(String what) {
        this.runtime.append("| ");
        this.runtime.appendPadded(what, ' ');
        this.runtime.append(' ');
    }
}

