/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.table;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import pl.mjaron.etudes.IPureAppendable;
import pl.mjaron.etudes.table.AlignmentMode;
import pl.mjaron.etudes.table.BlankTableWriter;
import pl.mjaron.etudes.table.ColumnSelector;
import pl.mjaron.etudes.table.ColumnWidthResolver;
import pl.mjaron.etudes.table.CsvEscaper;
import pl.mjaron.etudes.table.CsvTableWriter;
import pl.mjaron.etudes.table.HtmlEscaper;
import pl.mjaron.etudes.table.HtmlOptions;
import pl.mjaron.etudes.table.HtmlTableWriter;
import pl.mjaron.etudes.table.IEscaper;
import pl.mjaron.etudes.table.ITableSource;
import pl.mjaron.etudes.table.ITableWriter;
import pl.mjaron.etudes.table.ManipulatingTableSourceBuilder;
import pl.mjaron.etudes.table.MarkdownEscaper;
import pl.mjaron.etudes.table.MarkdownTableWriter;
import pl.mjaron.etudes.table.RenderOperation;
import pl.mjaron.etudes.table.VerticalAlign;
import pl.mjaron.etudes.table.property.ColumnOnlyPropertyProvider;

public class RenderContext {
    private final ManipulatingTableSourceBuilder tableSourceBuilder = new ManipulatingTableSourceBuilder();
    private final ColumnWidthResolver columnWidthResolver = new ColumnWidthResolver();
    private final ColumnOnlyPropertyProvider<VerticalAlign> verticalAlignPropertyProvider = new ColumnOnlyPropertyProvider();
    private ITableWriter writer = null;
    private IPureAppendable out = null;
    private File outFile = null;
    private IEscaper escaper = null;
    @Nullable
    private String cellDelimiter = null;
    private String lineBreak = System.lineSeparator();

    @NotNull
    public static RenderContext make() {
        return new RenderContext();
    }

    @NotNull
    public static ColumnSelector col(String id) {
        return new ColumnSelector().col(id);
    }

    @NotNull
    public static ColumnSelector col(String id, String alias) {
        return new ColumnSelector().col(id).as(alias);
    }

    @NotNull
    public ManipulatingTableSourceBuilder getTableSourceBuilder() {
        return this.tableSourceBuilder;
    }

    @NotNull
    public ColumnOnlyPropertyProvider<VerticalAlign> getVerticalAlignPropertyProvider() {
        return this.verticalAlignPropertyProvider;
    }

    @NotNull
    @Contract(value="_ -> this")
    public RenderContext to(IPureAppendable out) {
        this.out = out;
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public RenderContext to(PrintStream out) {
        return this.to(IPureAppendable.from(out));
    }

    @NotNull
    @Contract(value="_, _-> this")
    public RenderContext to(OutputStream out, Charset charset) {
        return this.to(IPureAppendable.from(out, charset));
    }

    @NotNull
    @Contract(value="_ -> this")
    public RenderContext to(OutputStream out) {
        return this.to(IPureAppendable.from(out));
    }

    @NotNull
    @Contract(value="_ -> this")
    public RenderContext to(StringBuilder out) {
        return this.to(IPureAppendable.from(out));
    }

    @NotNull
    @Contract(value="_ -> this")
    public RenderContext to(Appendable out) {
        if (out instanceof IPureAppendable) {
            return this.to((IPureAppendable)out);
        }
        return this.to(IPureAppendable.from(out));
    }

    @NotNull
    @Contract(value="_ -> this")
    public RenderContext to(File file) {
        this.out = null;
        this.outFile = file;
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public RenderContext toFile(@NotNull String path) {
        return this.to(new File(path));
    }

    @Nullable
    @Contract(pure=true)
    public ITableWriter getWriter() {
        return this.writer;
    }

    @NotNull
    @Contract(value="_ -> this")
    public RenderContext withWriter(ITableWriter writer) {
        this.writer = writer;
        return this;
    }

    @NotNull
    @Contract(value="-> this")
    public RenderContext withMarkdownWriter() {
        return this.withWriter(new MarkdownTableWriter());
    }

    @NotNull
    @Contract(value="-> this")
    public RenderContext withCsvWriter() {
        return this.withWriter(new CsvTableWriter());
    }

    @NotNull
    public RenderContext withHtmlWriter() {
        return this.withWriter(new HtmlTableWriter());
    }

    @NotNull
    public RenderContext withHtmlWriter(HtmlOptions htmlOptions) {
        return this.withWriter(new HtmlTableWriter(htmlOptions));
    }

    @NotNull
    public RenderContext withBlankTableWriter() {
        return this.withWriter(new BlankTableWriter());
    }

    @Nullable
    public IEscaper getEscaper() {
        return this.escaper;
    }

    @NotNull
    public RenderContext withEscaper(IEscaper escaper) {
        this.escaper = escaper;
        return this;
    }

    @NotNull
    public RenderContext withoutEscaper() {
        return this.withEscaper(null);
    }

    @NotNull
    @Contract(value="-> this")
    public RenderContext withMarkdownEscaper() {
        return this.withEscaper(MarkdownEscaper.getDefaultInstance());
    }

    @NotNull
    @Contract(value="-> this")
    public RenderContext withCsvEscaper() {
        return this.withEscaper(new CsvEscaper());
    }

    @NotNull
    @Contract(value="-> this")
    public RenderContext withHtmlEscaper() {
        return this.withEscaper(new HtmlEscaper());
    }

    @NotNull
    @Contract(pure=true)
    public ColumnWidthResolver getColumnWidthResolver() {
        return this.columnWidthResolver;
    }

    @NotNull
    @Contract(value="_,_-> this")
    public RenderContext withColumnWidths(AlignmentMode mode, int[] widths) {
        this.getColumnWidthResolver().configure(mode, widths);
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public RenderContext withArbitraryColumnWidths(int[] widths) {
        return this.withColumnWidths(AlignmentMode.ARBITRARY, widths);
    }

    @NotNull
    @Contract(value="-> this")
    public RenderContext withAlignedColumnWidths() {
        return this.withColumnWidths(AlignmentMode.ALIGNED, null);
    }

    @Deprecated
    @NotNull
    @Contract(value="_ -> this")
    public RenderContext withAlignedColumnWidths(Boolean alignedColumnWidths) {
        if (alignedColumnWidths == null) {
            this.getColumnWidthResolver().configure(AlignmentMode.DEFAULT);
        }
        if (Boolean.TRUE.equals(alignedColumnWidths)) {
            return this.withAlignedColumnWidths();
        }
        return this.withoutAlignedColumnWidths();
    }

    @Contract(value="-> this")
    @NotNull
    public RenderContext withoutAlignedColumnWidths() {
        return this.withColumnWidths(AlignmentMode.NOT_ALIGNED, null);
    }

    @Contract(value="-> this")
    @NotNull
    public RenderContext withEqualColumnWidths() {
        return this.withColumnWidths(AlignmentMode.EQUAL, null);
    }

    @Contract(value="_-> this")
    @NotNull
    public RenderContext withCellDelimiter(String delimiter) {
        this.cellDelimiter = delimiter;
        return this;
    }

    @Contract(value="_-> this")
    @NotNull
    public RenderContext withCellDelimiter(char delimiter) {
        this.cellDelimiter = String.valueOf(delimiter);
        return this;
    }

    @NotNull
    @Contract(value="-> this")
    public RenderContext withDefaultCellDelimiter() {
        return this.withCellDelimiter(null);
    }

    @NotNull
    @Contract(value="-> this")
    public RenderContext withoutCellDelimiter() {
        return this.withCellDelimiter("");
    }

    @Nullable
    @Contract(pure=true)
    public String getCellDelimiter() {
        return this.cellDelimiter;
    }

    @NotNull
    @Contract(value="_-> this")
    public RenderContext withLineBreak(@NotNull String lineBreak) {
        this.lineBreak = lineBreak;
        return this;
    }

    @NotNull
    @Contract(value="-> this")
    public RenderContext withLineBreakLF() {
        return this.withLineBreak("\n");
    }

    @NotNull
    @Contract(value="-> this")
    public RenderContext withLineBreakCRLF() {
        return this.withLineBreak("\r\n");
    }

    @NotNull
    @Contract(value="-> this")
    public RenderContext withLineBreakCR() {
        return this.withLineBreak("\r");
    }

    @NotNull
    @Contract(value="_-> this")
    public RenderContext withAlign(@Nullable VerticalAlign align) {
        this.verticalAlignPropertyProvider.put(align);
        return this;
    }

    @NotNull
    @Contract(value="_, _-> this")
    public RenderContext withAlign(@Range(from=0L, to=0x7FFFFFFFL) int column, @Nullable VerticalAlign align) {
        this.verticalAlignPropertyProvider.put(column, align);
        return this;
    }

    @Contract(value="_-> this")
    public RenderContext withColumns(ColumnSelector columnSelector) {
        this.getTableSourceBuilder().setColumnSelector(columnSelector);
        this.getTableSourceBuilder().setAllColumns(false);
        return this;
    }

    @Contract(value="_-> this")
    public RenderContext withColumnNames(ColumnSelector columnSelector) {
        this.getTableSourceBuilder().setColumnSelector(columnSelector);
        this.getTableSourceBuilder().setAllColumns(true);
        return this;
    }

    @NotNull
    @Contract(value="-> this")
    public RenderContext markdown() {
        return this.withMarkdownWriter().withMarkdownEscaper();
    }

    @NotNull
    @Contract(value="-> this")
    public RenderContext csv() {
        return this.withCsvWriter().withCsvEscaper().withLineBreakCRLF();
    }

    @NotNull
    @Contract(value="-> this")
    public RenderContext html() {
        return this.withHtmlWriter().withHtmlEscaper();
    }

    @NotNull
    @Contract(value="_-> this")
    public RenderContext html(@NotNull HtmlOptions htmlOptions) {
        return this.withHtmlWriter(htmlOptions).withHtmlEscaper();
    }

    @NotNull
    @Contract(pure=true)
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Nullable
    @Contract(pure=true)
    public IPureAppendable getOut() {
        return this.out;
    }

    @Nullable
    @Contract(pure=true)
    public File getOutFile() {
        return this.outFile;
    }

    public void setSource(ITableSource source) {
        this.getTableSourceBuilder().setUnderlyingSource(source);
    }

    public void run() {
        RenderOperation.execute(this);
    }

    @NotNull
    @Contract(pure=true)
    public String runToString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getOut() != null) {
            throw new IllegalArgumentException("Cannot render to String: Invalid render context: Appender already set with " + RenderContext.class.getSimpleName() + "::to(...) method.");
        }
        this.to(stringBuilder);
        RenderOperation.execute(this);
        return stringBuilder.toString();
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public String runString() {
        return this.runToString();
    }
}

