/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.table;

import pl.mjaron.etudes.table.ITableSource;
import pl.mjaron.etudes.table.ITableWriter;
import pl.mjaron.etudes.table.RenderContext;
import pl.mjaron.etudes.table.RenderRuntime;

public abstract class RenderOperation {
    public static void execute(RenderContext context) {
        try (RenderRuntime runtime = new RenderRuntime(context);){
            context.getColumnWidthResolver().resolve(runtime);
            ITableSource source = runtime.getSource();
            ITableWriter writer = runtime.getWriter();
            runtime.getEscaper().beginTable(runtime);
            writer.beginTable(runtime);
            if (runtime.getSource().hasHeaders()) {
                runtime.setHeaderState(true);
                writer.beginHeader();
                runtime.resetColumn();
                for (String header : source.getHeaders()) {
                    writer.writeCell(runtime.getEscaper().escape(header));
                    runtime.nextColumn();
                }
                writer.endHeader();
                runtime.setHeaderState(false);
            }
            for (Iterable<String> row : source) {
                writer.beginRow();
                runtime.resetColumn();
                for (String cell : row) {
                    writer.writeCell(runtime.getEscaper().escape(cell));
                    runtime.nextColumn();
                }
                writer.endRow();
            }
            writer.endTable();
        }
        catch (Exception e) {
            throw new RuntimeException("Render operation failed.", e);
        }
    }
}

