/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.table;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.Range;
import pl.mjaron.etudes.IPureAppendable;
import pl.mjaron.etudes.Str;
import pl.mjaron.etudes.table.IEscaper;
import pl.mjaron.etudes.table.ITableSource;
import pl.mjaron.etudes.table.ITableWriter;
import pl.mjaron.etudes.table.MarkdownTableWriter;
import pl.mjaron.etudes.table.RenderContext;
import pl.mjaron.etudes.table.VerticalAlign;

public class RenderRuntime
implements AutoCloseable {
    private final RenderContext context;
    private final ITableSource tableSource;
    private final IEscaper escaper;
    OutputStream internalOutputStream = null;
    private final IPureAppendable out;
    private final String cellDelimiter;
    private int columnIdx = 0;
    private boolean headerState = false;

    public RenderRuntime(RenderContext context) {
        this.context = context;
        this.tableSource = context.getTableSourceBuilder().build();
        this.escaper = IEscaper.dummyOr(context.getEscaper());
        IPureAppendable tmpOut = null;
        if (context.getOutFile() != null) {
            try {
                this.internalOutputStream = new FileOutputStream(context.getOutFile());
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Failed to create output stream.", e);
            }
            tmpOut = IPureAppendable.from(this.internalOutputStream);
        }
        if (context.getWriter() == null) {
            context.withWriter(new MarkdownTableWriter());
        }
        IPureAppendable iPureAppendable = tmpOut != null ? tmpOut : (this.out = context.getOut() != null ? context.getOut() : IPureAppendable.from(System.out));
        this.cellDelimiter = context.getCellDelimiter() != null ? context.getCellDelimiter() : (this.getWriter().getDefaultDelimiter() != null ? this.getWriter().getDefaultDelimiter() : null);
    }

    public RenderContext getContext() {
        return this.context;
    }

    public ITableSource getSource() {
        return this.tableSource;
    }

    public IPureAppendable getOut() {
        return this.out;
    }

    public IEscaper getEscaper() {
        return this.escaper;
    }

    public ITableWriter getWriter() {
        return this.getContext().getWriter();
    }

    public String getCellDelimiter() {
        return this.cellDelimiter;
    }

    public String getLineBreak() {
        return this.context.getLineBreak();
    }

    public boolean hasColumnWidths() {
        return this.context.getColumnWidthResolver().hasWidths();
    }

    public int getColumnWidth(int columnIndex) {
        return this.context.getColumnWidthResolver().getWidth(columnIndex);
    }

    public int getColumnsCount() {
        return this.getSource().getColumnsCount();
    }

    public int getColumnIdx() {
        return this.columnIdx;
    }

    public void nextColumn() {
        ++this.columnIdx;
    }

    public void resetColumn() {
        this.columnIdx = 0;
    }

    public boolean isHeaderState() {
        return this.headerState;
    }

    public void setHeaderState(boolean headerState) {
        this.headerState = headerState;
    }

    public VerticalAlign getCurrentColumnVerticalAlign() {
        return this.getVerticalAlign(this.columnIdx);
    }

    public VerticalAlign getVerticalAlign(@Range(from=0L, to=0x7FFFFFFFL) int column) {
        return this.getContext().getVerticalAlignPropertyProvider().get(column, -1);
    }

    public void append(String what) {
        this.getOut().append(what);
    }

    public void append(char what) {
        this.getOut().append(what);
    }

    public void appendLine() {
        this.append(this.getContext().getLineBreak());
    }

    public void appendLine(String what) {
        this.append(what);
        this.appendLine();
    }

    public void appendLine(char what) {
        this.append(what);
        this.appendLine();
    }

    public void appendIfNotFirstColumn(String what) {
        if (this.columnIdx != 0) {
            this.append(what);
        }
    }

    public void appendIfNotFirstColumn(char what) {
        if (this.columnIdx != 0) {
            this.append(what);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void appendPadded(String what, char fillChar) {
        VerticalAlign currentAlign = this.getContext().getVerticalAlignPropertyProvider().get(this.columnIdx, -1);
        if (this.getContext().getColumnWidthResolver().hasWidths()) {
            if (currentAlign == null || currentAlign == VerticalAlign.Left) {
                Str.padRight(what, this.getContext().getColumnWidthResolver().getWidth(this.columnIdx), fillChar, this.getOut());
                return;
            } else if (currentAlign == VerticalAlign.Right) {
                Str.padLeft(what, this.getContext().getColumnWidthResolver().getWidth(this.columnIdx), fillChar, this.getOut());
                return;
            } else {
                if (currentAlign != VerticalAlign.Center) throw new RuntimeException("Unsupported vertical align value: " + (Object)((Object)currentAlign));
                Str.padCenter(what, this.getContext().getColumnWidthResolver().getWidth(this.columnIdx), fillChar, this.getOut());
            }
            return;
        } else {
            this.append(what);
        }
    }

    public void appendPadded(String what) {
        this.appendPadded(what, ' ');
    }

    @Override
    public void close() {
        if (this.internalOutputStream != null) {
            try {
                this.internalOutputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to close output stream.", e);
            }
        }
    }
}

