/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.table;

import org.jetbrains.annotations.NotNull;
import pl.mjaron.etudes.table.DummyEscaper;
import pl.mjaron.etudes.table.IEscaper;
import pl.mjaron.etudes.table.ITableSource;

public abstract class TableColumnsWidthDetector {
    private static void applyRow(int[] widths, Iterable<String> series, IEscaper escaper) {
        int i = 0;
        for (String entry : series) {
            int newEntryWidth;
            int oldEntryWidth = widths[i];
            widths[i] = newEntryWidth = Integer.max(oldEntryWidth, escaper.escape(entry).length());
            ++i;
        }
    }

    public static int[] compute(@NotNull ITableSource source, @NotNull IEscaper escaper) {
        int[] widths = new int[source.getColumnsCount()];
        if (source.hasHeaders()) {
            TableColumnsWidthDetector.applyRow(widths, source.getHeaders(), escaper);
        }
        for (Iterable<String> row : source) {
            TableColumnsWidthDetector.applyRow(widths, row, escaper);
        }
        return widths;
    }

    public static int[] compute(ITableSource source) {
        return TableColumnsWidthDetector.compute(source, DummyEscaper.getInstance());
    }
}

