/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.table;

import java.util.Iterator;
import pl.mjaron.etudes.table.ITableSource;
import pl.mjaron.etudes.table.SeriesIteratorFactory;

public abstract class TableSourceFactory {
    ITableSource from(final int[][] data) {
        return new ITableSource(){

            @Override
            public int getColumnsCount() {
                return data.length == 0 ? 0 : data[0].length;
            }

            @Override
            public Iterable<String> getHeaders() {
                return null;
            }

            @Override
            public Iterator<Iterable<String>> iterator() {
                return new Iterator<Iterable<String>>(){
                    int rowIdx = 0;

                    @Override
                    public boolean hasNext() {
                        return this.rowIdx < data.length;
                    }

                    @Override
                    public Iterable<String> next() {
                        return () -> SeriesIteratorFactory.from(data[this.rowIdx++]);
                    }
                };
            }
        };
    }
}

