/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.text;

import org.jetbrains.annotations.ApiStatus;
import pl.mjaron.etudes.IPureAppendable;
import pl.mjaron.etudes.Str;
import pl.mjaron.etudes.table.RenderContext;

@ApiStatus.Experimental
public class SimpleMarkdownWriter {
    private final IPureAppendable out;

    public SimpleMarkdownWriter(IPureAppendable out) {
        this.out = out;
    }

    public SimpleMarkdownWriter() {
        this.out = IPureAppendable.from(new StringBuilder());
    }

    public IPureAppendable getOut() {
        return this.out;
    }

    public String getOutString() {
        if (this.out.getUnderlyingObject() instanceof StringBuilder) {
            return ((StringBuilder)this.out.getUnderlyingObject()).toString();
        }
        throw new RuntimeException("Only " + StringBuilder.class.getSimpleName() + " class can be used with getOutputString().");
    }

    public void header(int nestLevel, String what) {
        Str.pad(this.out, nestLevel, '#');
        this.out.append(' ');
        this.out.append(what);
        this.out.append("\n\n");
    }

    public void writeRaw(String what) {
        this.out.append(what);
    }

    public void nextParagraph() {
        this.out.append("\n\n");
    }

    public void lineBreak() {
        this.out.append("  \n");
    }

    public void codeBlock(String what) {
        this.out.append("    ");
        this.out.append(what.replace("\n", "    \n"));
        this.out.append("\n\n");
    }

    public void fencedCodeBlock(String lang, String code) {
        this.out.append("```");
        if (lang != null) {
            this.out.append(lang);
        }
        this.out.append("\n");
        this.out.append(code);
        this.out.append("\n```\n\n");
    }

    public void table(RenderContext render) {
        render.to(this.out);
        render.run();
        this.out.append("\n");
    }

    public void paragraph(String what) {
        this.out.append(what);
        this.out.append("\n\n");
    }

    public void writeRawLine(String what) {
        this.out.append(what);
        this.out.append("\n");
    }
}

