/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.tinyloki;

import java.util.Map;
import pl.mjaron.tinyloki.ILogStream;
import pl.mjaron.tinyloki.JsonLogCollector;
import pl.mjaron.tinyloki.Labels;
import pl.mjaron.tinyloki.Utils;

public class JsonLogStream
implements ILogStream {
    private final JsonLogCollector collector;
    private final StringBuilder b = new StringBuilder("{\"stream\":{");
    private final String initialSequenceWithHeaders;
    private int cachedLogsCount = 0;

    public JsonLogStream(JsonLogCollector collector, Labels labels) {
        this.collector = collector;
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : labels.getMap().entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.b.append(',');
            }
            this.b.append('\"');
            this.b.append(entry.getKey());
            this.b.append('\"');
            this.b.append(':');
            this.b.append('\"');
            Utils.escapeJsonString(this.b, entry.getValue());
            this.b.append('\"');
        }
        this.b.append("},\"values\":[");
        this.initialSequenceWithHeaders = this.b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(long timestampMs, String line) {
        JsonLogStream jsonLogStream = this;
        synchronized (jsonLogStream) {
            if (this.cachedLogsCount != 0) {
                this.b.append(',');
            }
            ++this.cachedLogsCount;
            this.b.append("[\"");
            this.b.append(timestampMs);
            this.b.append("000000\",\"");
            Utils.escapeJsonString(this.b, line);
            this.b.append("\"]");
        }
        this.collector.logOccurred();
    }

    @Override
    public void release() {
        this.collector.onStreamReleased(this);
    }

    public void closeStreamsEntryTag() {
        this.b.append("]}");
    }

    public StringBuilder getStringBuilder() {
        return this.b;
    }

    public void clear() {
        this.b.setLength(0);
        this.b.append(this.initialSequenceWithHeaders);
        this.cachedLogsCount = 0;
    }

    public synchronized String flush() {
        if (this.cachedLogsCount == 0) {
            return null;
        }
        this.closeStreamsEntryTag();
        String result = this.b.toString();
        this.clear();
        return result;
    }
}

