/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.tinyloki;

import java.util.Map;
import pl.mjaron.tinyloki.ErrorLogMonitor;
import pl.mjaron.tinyloki.GzipLogEncoder;
import pl.mjaron.tinyloki.HttpLogSender;
import pl.mjaron.tinyloki.ILogCollector;
import pl.mjaron.tinyloki.ILogEncoder;
import pl.mjaron.tinyloki.ILogMonitor;
import pl.mjaron.tinyloki.ILogSender;
import pl.mjaron.tinyloki.JsonLogCollector;
import pl.mjaron.tinyloki.LabelSettings;
import pl.mjaron.tinyloki.Labels;
import pl.mjaron.tinyloki.LogController;
import pl.mjaron.tinyloki.LogSenderSettings;
import pl.mjaron.tinyloki.VerboseLogMonitor;

public class TinyLoki {
    public static Settings withUrl(String url) {
        return new Settings(url);
    }

    public static LogController createAndStart(Settings settings) {
        return new LogController(settings.getLogCollector(), settings.getLogEncoder(), settings.getLogSenderSettings(), settings.getLogSender(), settings.getLabelSettings(), settings.getLogMonitor()).start();
    }

    public static LogController createAndStart(String url, String user, String pass) {
        return TinyLoki.withUrl(url).withBasicAuth(user, pass).start();
    }

    public static LogController createAndStart(String url, String user, String pass, int connectTimeout) {
        return TinyLoki.withUrl(url).withBasicAuth(user, pass).withConnectTimeout(connectTimeout).start();
    }

    public static LogController createAndStart(String url, String user, String pass, ILogCollector logCollector, ILogMonitor logMonitor) {
        return TinyLoki.withUrl(url).withBasicAuth(user, pass).withLogCollector(logCollector).withLogMonitor(logMonitor).start();
    }

    public static LogController createAndStart(String url, String user, String pass, int connectTimeout, ILogCollector logCollector, ILogMonitor logMonitor) {
        return TinyLoki.withUrl(url).withBasicAuth(user, pass).withConnectTimeout(connectTimeout).withLogCollector(logCollector).withLogMonitor(logMonitor).start();
    }

    public static Labels l(String labelName, String labelValue) {
        return new Labels().l(labelName, labelValue);
    }

    public static Labels l(Map<String, String> map) {
        return new Labels().l(map);
    }

    public static Labels l(Labels other) {
        return new Labels(other);
    }

    public static Labels critical() {
        return new Labels().critical();
    }

    public static Labels fatal() {
        return new Labels().fatal();
    }

    public static Labels warning() {
        return new Labels().warning();
    }

    public static Labels info() {
        return new Labels().info();
    }

    public static Labels debug() {
        return new Labels().debug();
    }

    public static Labels verbose() {
        return new Labels().verbose();
    }

    public static Labels trace() {
        return new Labels().trace();
    }

    public static Labels unknown() {
        return new Labels().unknown();
    }

    public static class Settings {
        private final LogSenderSettings logSenderSettings = LogSenderSettings.create();
        private ILogCollector logCollector = null;
        private ILogEncoder logEncoder = null;
        private ILogMonitor logMonitor = null;
        private ILogSender logSender = null;
        private final LabelSettings labelSettings = new LabelSettings();

        public Settings(String url) {
            this.logSenderSettings.setUrl(url);
        }

        public Settings withBasicAuth(String user, String pass) {
            this.logSenderSettings.setUser(user);
            this.logSenderSettings.setPassword(pass);
            return this;
        }

        public Settings withConnectTimeout(int connectTimeout) {
            this.logSenderSettings.setConnectTimeout(connectTimeout);
            return this;
        }

        public Settings withLogCollector(ILogCollector logCollector) {
            this.logCollector = logCollector;
            return this;
        }

        public Settings withLogEncoder(ILogEncoder logEncoder) {
            this.logEncoder = logEncoder;
            return this;
        }

        public Settings withGzipLogEncoder() {
            return this.withLogEncoder(new GzipLogEncoder());
        }

        public Settings withoutLogEncoder() {
            return this.withLogEncoder(null);
        }

        public Settings withLogMonitor(ILogMonitor logMonitor) {
            this.logMonitor = logMonitor;
            return this;
        }

        public Settings withErrorLogMonitor() {
            return this.withLogMonitor(new ErrorLogMonitor());
        }

        public Settings withVerboseLogMonitor() {
            return this.withLogMonitor(new VerboseLogMonitor());
        }

        public Settings withLogSender(ILogSender logSender) {
            this.logSender = logSender;
            return this;
        }

        public Settings withLabelLength(int maxLabelNameLength, int maxLabelValueLength) {
            this.labelSettings.setMaxLabelNameLength(maxLabelNameLength);
            this.labelSettings.setMaxLabelValueLength(maxLabelValueLength);
            return this;
        }

        public LogSenderSettings getLogSenderSettings() {
            return this.logSenderSettings;
        }

        public ILogCollector getLogCollector() {
            return this.logCollector != null ? this.logCollector : new JsonLogCollector();
        }

        public ILogEncoder getLogEncoder() {
            return this.logEncoder;
        }

        public ILogMonitor getLogMonitor() {
            return this.logMonitor != null ? this.logMonitor : new ErrorLogMonitor();
        }

        public ILogSender getLogSender() {
            return this.logSender != null ? this.logSender : new HttpLogSender();
        }

        public LabelSettings getLabelSettings() {
            return this.labelSettings;
        }

        public LogController start() {
            return TinyLoki.createAndStart(this);
        }
    }
}

