/*
 * Decompiled with CFR 0.152.
 */
package io.github.mjourard;

import io.github.cdimascio.dotenv.Dotenv;
import io.github.cdimascio.dotenv.DotenvEntry;
import io.github.cdimascio.dotenv.DotenvException;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="loadenv", defaultPhase=LifecyclePhase.TEST)
public class LoadEnvMojo
extends AbstractMojo {
    @Parameter(defaultValue="./", property="envFileDirectory", required=true)
    private String envFileDirectory;
    @Parameter(defaultValue=".env", property="envFileName", required=true)
    private String envFileName;
    @Parameter(property="skip", required=false, defaultValue="false")
    private Boolean skip;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"'skip' property found and set to true. Skipping the 'env-file-maven-plugin' plugin.");
            return;
        }
        if (this.envFileDirectory == null || this.envFileDirectory.isEmpty()) {
            throw new MojoFailureException("env file directory was empty");
        }
        if (this.envFileName == null || this.envFileName.isEmpty()) {
            throw new MojoFailureException("env file name was empty");
        }
        String tempEnvFileDirectory = this.evaluatePath(this.envFileDirectory);
        this.getLog().info((CharSequence)("Loading env file from '" + LoadEnvMojo.makePathDirectory(tempEnvFileDirectory) + FileSystems.getDefault().getSeparator() + this.envFileName + "'"));
        Dotenv dotenv = null;
        try {
            dotenv = Dotenv.configure().directory(tempEnvFileDirectory).filename(this.envFileName).systemProperties().load();
        }
        catch (DotenvException dee) {
            throw new MojoExecutionException("Error while loading env file", (Exception)((Object)dee));
        }
        HashMap<String, String> newEnv = new HashMap<String, String>();
        for (DotenvEntry entry : dotenv.entries()) {
            newEnv.put(entry.getKey(), entry.getValue());
        }
        try {
            LoadEnvMojo.setEnv(newEnv);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while loading environment variables from parsed env file", e);
        }
    }

    private String evaluatePath(String path) {
        return this.project.getModel().getProjectDirectory().toPath().resolve(path).normalize().toAbsolutePath().toString();
    }

    public static String makePathDirectory(String path) {
        if (Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0])) {
            return path;
        }
        return path + File.separator;
    }

    protected static void setEnv(Map<String, String> newenv) throws Exception {
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            Field theEnvironmentField = processEnvironmentClass.getDeclaredField("theEnvironment");
            theEnvironmentField.setAccessible(true);
            Map env = (Map)theEnvironmentField.get(null);
            env.putAll(newenv);
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
            cienv.putAll(newenv);
        }
        catch (NoSuchFieldException e) {
            Class<?>[] classes = Collections.class.getDeclaredClasses();
            Map<String, String> env = System.getenv();
            for (Class<?> cl : classes) {
                if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                Field field = cl.getDeclaredField("m");
                field.setAccessible(true);
                Object obj = field.get(env);
                Map map = (Map)obj;
                map.clear();
                map.putAll(newenv);
            }
        }
    }
}

