/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.util;

import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.util.StringConverter;

public class IntegerStringConverter
extends StringConverter<Integer> {
    private Runnable reset;

    public IntegerStringConverter() {
    }

    public IntegerStringConverter(Runnable reset) {
        this.reset = reset;
    }

    public IntegerStringConverter(TextField input, int min, int max) {
        if (input == null) {
            throw new NullPointerException("Input cannot be null!");
        }
        int resetValue = Math.min(Math.max(0, min), max);
        this.reset = () -> input.setText(Integer.toString(resetValue));
        input.textProperty().addListener((ov, oldValue, newValue) -> {
            if (newValue == null || newValue.isEmpty()) {
                return;
            }
            if (min < 0 && newValue.endsWith("-")) {
                if (newValue.length() > 1) {
                    Platform.runLater(() -> input.setText("-"));
                }
                return;
            }
            try {
                Integer.parseInt(newValue);
            }
            catch (NumberFormatException e) {
                Platform.runLater(() -> input.setText(oldValue));
            }
        });
        EventHandler oldHandler = input.getOnAction();
        input.setOnAction(t -> {
            int restricted;
            int value = this.fromString(input.getText());
            if (value != (restricted = Math.min(Math.max(value, min), max))) {
                input.setText(Integer.toString(restricted));
            }
            if (oldHandler != null) {
                oldHandler.handle(t);
            }
        });
    }

    public static IntegerStringConverter createFor(Spinner<Integer> spinner) {
        SpinnerValueFactory.IntegerSpinnerValueFactory factory = (SpinnerValueFactory.IntegerSpinnerValueFactory)spinner.getValueFactory();
        IntegerStringConverter converter = new IntegerStringConverter(spinner.getEditor(), factory.getMin(), factory.getMax());
        factory.setConverter((StringConverter)converter);
        spinner.setTooltip(new Tooltip(String.format("Enter a value between %d and %d", factory.getMin(), factory.getMax())));
        return converter;
    }

    public void setReset(Runnable reset) {
        this.reset = reset;
    }

    public Integer fromString(String s) {
        if (s == null || s.isEmpty()) {
            if (this.reset != null) {
                this.reset.run();
            }
            return 0;
        }
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            if (this.reset != null) {
                this.reset.run();
            }
            return 0;
        }
    }

    public String toString(Integer value) {
        if (value == null) {
            return "0";
        }
        return Integer.toString(value);
    }
}

