/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.CalendarSkin;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.DateCell;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import org.jetbrains.annotations.Nullable;

public class Calendar
extends Control {
    protected LocalDate lastValidDate = null;
    protected Chronology lastValidChronology = IsoChronology.INSTANCE;
    private final ObjectProperty<LocalDate> value = new SimpleObjectProperty((Object)this, "value");
    private ObjectProperty<Callback<Calendar, DateCell>> dayCellFactory;
    private final ObjectProperty<Chronology> chronology = new SimpleObjectProperty((Object)this, "chronology", null);
    private BooleanProperty showWeekNumbers;
    private final ObjectProperty<Node> topNode = new SimpleObjectProperty((Object)this, "topNode", null);
    private final ObjectProperty<Node> bottomNode = new SimpleObjectProperty((Object)this, "bottomNode", null);
    private static final String DEFAULT_STYLE_CLASS = "calendar";

    public Calendar() {
        this(null);
        this.valueProperty().addListener(obs -> {
            LocalDate date = this.getValue();
            Chronology chrono = this.getChronology();
            if (Calendar.isValidDate(chrono, date)) {
                this.lastValidDate = date;
            } else {
                System.err.println("[ERROR] Restoring value to " + (Serializable)(this.lastValidDate == null ? "null" : this.lastValidDate));
                this.setValue(this.lastValidDate);
            }
        });
        this.chronologyProperty().addListener(observable -> {
            LocalDate date = this.getValue();
            Chronology chrono = this.getChronology();
            if (Calendar.isValidDate(chrono, date)) {
                this.lastValidChronology = chrono;
            } else {
                System.err.println("[ERROR] Restoring value to " + this.lastValidChronology);
                this.setChronology(this.lastValidChronology);
            }
        });
    }

    public Calendar(@Nullable LocalDate localDate) {
        this.setValue(localDate);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    protected Skin<?> createDefaultSkin() {
        return new CalendarSkin(this);
    }

    public ObjectProperty<LocalDate> valueProperty() {
        return this.value;
    }

    public final LocalDate getValue() {
        return (LocalDate)this.valueProperty().get();
    }

    public final void setValue(LocalDate value) {
        this.valueProperty().set((Object)value);
    }

    public final void setDayCellFactory(Callback<Calendar, DateCell> value) {
        this.dayCellFactoryProperty().set(value);
    }

    public final Callback<Calendar, DateCell> getDayCellFactory() {
        return this.dayCellFactory != null ? (Callback)this.dayCellFactory.get() : null;
    }

    public final ObjectProperty<Callback<Calendar, DateCell>> dayCellFactoryProperty() {
        if (this.dayCellFactory == null) {
            this.dayCellFactory = new SimpleObjectProperty((Object)this, "dayCellFactory");
        }
        return this.dayCellFactory;
    }

    public ObjectProperty<Chronology> chronologyProperty() {
        return this.chronology;
    }

    public final Chronology getChronology() {
        Chronology chrono = (Chronology)this.chronology.get();
        if (chrono == null) {
            try {
                chrono = Chronology.ofLocale(Locale.getDefault(Locale.Category.FORMAT));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (chrono == null) {
                chrono = IsoChronology.INSTANCE;
            }
        }
        return chrono;
    }

    public final void setChronology(Chronology value) {
        this.chronology.setValue((Object)value);
    }

    public final BooleanProperty showWeekNumbersProperty() {
        if (this.showWeekNumbers == null) {
            this.showWeekNumbers = new StyleableBooleanProperty(false){

                public CssMetaData<Calendar, Boolean> getCssMetaData() {
                    return StyleableProperties.SHOW_WEEK_NUMBERS;
                }

                public Object getBean() {
                    return Calendar.this;
                }

                public String getName() {
                    return "showWeekNumbers";
                }
            };
        }
        return this.showWeekNumbers;
    }

    public final void setShowWeekNumbers(boolean value) {
        this.showWeekNumbersProperty().setValue(Boolean.valueOf(value));
    }

    public final boolean isShowWeekNumbers() {
        return this.showWeekNumbersProperty().getValue();
    }

    public ObjectProperty<Node> topNodeProperty() {
        return this.topNode;
    }

    public final void setTopNode(Node value) {
        this.topNode.setValue((Object)value);
    }

    public final Node getTopNode() {
        return (Node)this.topNode.getValue();
    }

    public ObjectProperty<Node> bottomNodeProperty() {
        return this.bottomNode;
    }

    public final void setBottomNode(Node value) {
        this.bottomNode.setValue((Object)value);
    }

    public final Node getBottomNode() {
        return (Node)this.bottomNode.getValue();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Calendar.getClassCssMetaData();
    }

    static boolean isValidDate(Chronology chrono, LocalDate date, int offset, ChronoUnit unit) {
        if (date != null) {
            try {
                return Calendar.isValidDate(chrono, date.plus(offset, unit));
            }
            catch (DateTimeException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    static boolean isValidDate(Chronology chrono, LocalDate date) {
        try {
            if (date != null) {
                chrono.date(date);
            }
            return true;
        }
        catch (DateTimeException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
        private static final CssMetaData<Calendar, Boolean> SHOW_WEEK_NUMBERS;

        private StyleableProperties() {
        }

        static {
            SHOW_WEEK_NUMBERS = new CssMetaData<Calendar, Boolean>("-fx-show-week-numbers", BooleanConverter.getInstance(), Boolean.valueOf(false)){

                public boolean isSettable(Calendar n) {
                    return n.showWeekNumbers == null || !n.showWeekNumbers.isBound();
                }

                public StyleableProperty<Boolean> getStyleableProperty(Calendar n) {
                    return (StyleableProperty)n.showWeekNumbersProperty();
                }
            };
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, SHOW_WEEK_NUMBERS);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

