/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.ModalPane;
import atlantafx.base.util.Animations;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.jetbrains.annotations.Nullable;

public class ModalPaneSkin
extends SkinBase<ModalPane> {
    protected ModalPane control;
    protected final StackPane root;
    protected final ScrollPane scrollPane;
    protected final StackPane contentWrapper;
    protected final EventHandler<KeyEvent> keyHandler = this.createKeyHandler();
    protected final EventHandler<MouseEvent> mouseHandler = this.createMouseHandler();
    protected final ChangeListener<Animation.Status> animationInListener = this.createAnimationInListener();
    protected final ChangeListener<Animation.Status> animationOutListener = this.createAnimationOutListener();
    @Nullable
    protected List<ScrollBar> scrollbars;
    @Nullable
    protected Animation inTransition;
    @Nullable
    protected Animation outTransition;

    protected ModalPaneSkin(ModalPane control) {
        super((Control)control);
        this.root = new StackPane();
        this.contentWrapper = new StackPane();
        this.contentWrapper.getStyleClass().add((Object)"scrollable-content");
        this.contentWrapper.setAlignment(Pos.CENTER);
        this.scrollPane = new ScrollPane();
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.setFitToHeight(true);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setMaxHeight(20000.0);
        this.scrollPane.setContent((Node)this.contentWrapper);
        this.getChildren().add((Object)this.scrollPane);
        control.getStyleClass().add((Object)"modal-pane");
        this.doHide();
        this.registerListeners();
    }

    protected void registerListeners() {
        this.registerChangeListener((ObservableValue)((ModalPane)this.getSkinnable()).contentProperty(), obs -> {
            @Nullable Node content = ((ModalPane)this.getSkinnable()).getContent();
            if (this.inTransition != null && content != null) {
                this.inTransition.statusProperty().removeListener(this.animationInListener);
            }
            this.inTransition = null;
            if (this.outTransition != null && content != null) {
                this.outTransition.statusProperty().removeListener(this.animationOutListener);
            }
            this.outTransition = null;
            if (content != null) {
                this.contentWrapper.getChildren().setAll((Object[])new Node[]{content});
            } else {
                this.contentWrapper.getChildren().clear();
            }
            this.contentWrapper.layout();
        });
        this.registerChangeListener((ObservableValue)((ModalPane)this.getSkinnable()).displayProperty(), obs -> {
            boolean display = ((ModalPane)this.getSkinnable()).isDisplay();
            if (display) {
                this.show();
            } else {
                this.hide();
            }
        });
        this.registerChangeListener((ObservableValue)((ModalPane)this.getSkinnable()).inTransitionFactoryProperty(), obs -> {
            if (this.inTransition != null) {
                this.inTransition.statusProperty().removeListener(this.animationInListener);
            }
            this.inTransition = null;
        });
        this.registerChangeListener((ObservableValue)((ModalPane)this.getSkinnable()).outTransitionFactoryProperty(), obs -> {
            if (this.outTransition != null) {
                this.outTransition.statusProperty().removeListener(this.animationOutListener);
            }
            this.outTransition = null;
        });
        this.contentWrapper.paddingProperty().bind((ObservableValue)((ModalPane)this.getSkinnable()).paddingProperty());
        this.contentWrapper.alignmentProperty().bind(((ModalPane)this.getSkinnable()).alignmentProperty());
        this.scrollPane.addEventHandler(KeyEvent.KEY_PRESSED, this.keyHandler);
        this.scrollPane.addEventFilter(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
    }

    public void dispose() {
        super.dispose();
        this.unregisterChangeListeners((ObservableValue)((ModalPane)this.getSkinnable()).contentProperty());
        this.unregisterChangeListeners((ObservableValue)((ModalPane)this.getSkinnable()).displayProperty());
        this.unregisterChangeListeners((ObservableValue)((ModalPane)this.getSkinnable()).inTransitionFactoryProperty());
        this.unregisterChangeListeners((ObservableValue)((ModalPane)this.getSkinnable()).outTransitionFactoryProperty());
        this.contentWrapper.paddingProperty().unbind();
        this.contentWrapper.alignmentProperty().unbind();
        this.scrollPane.removeEventFilter(KeyEvent.KEY_PRESSED, this.keyHandler);
        this.scrollPane.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
    }

    protected boolean isClickInArea(MouseEvent e, Node area) {
        return e.getX() >= area.getLayoutX() & e.getX() <= area.getLayoutX() + area.getLayoutBounds().getWidth() && e.getY() >= area.getLayoutY() & e.getY() <= area.getLayoutY() + area.getLayoutBounds().getHeight();
    }

    protected EventHandler<KeyEvent> createKeyHandler() {
        return event -> {
            if (event.getCode() == KeyCode.ESCAPE) {
                if (((ModalPane)this.getSkinnable()).getPersistent()) {
                    this.createCloseBlockedAnimation().playFromStart();
                } else {
                    this.hideAndConsume(event);
                }
            }
        };
    }

    protected EventHandler<MouseEvent> createMouseHandler() {
        return event -> {
            boolean scrollBarClick;
            @Nullable Node content = ((ModalPane)this.getSkinnable()).getContent();
            if (event.getButton() != MouseButton.PRIMARY) {
                return;
            }
            if (content == null) {
                this.hideAndConsume(event);
                return;
            }
            if (this.isClickInArea((MouseEvent)event, content)) {
                return;
            }
            if (this.scrollbars == null || this.scrollbars.isEmpty()) {
                this.scrollbars = this.scrollPane.lookupAll(".scroll-bar").stream().filter(node -> node instanceof ScrollBar).map(node -> (ScrollBar)node).toList();
            }
            if (!(scrollBarClick = this.scrollbars.stream().anyMatch(scrollBar -> this.isClickInArea((MouseEvent)event, (Node)scrollBar)))) {
                if (((ModalPane)this.getSkinnable()).getPersistent()) {
                    this.createCloseBlockedAnimation().playFromStart();
                } else {
                    this.hideAndConsume(event);
                }
            }
        };
    }

    protected ChangeListener<Animation.Status> createAnimationInListener() {
        return (obs, old, val) -> {
            if (val == Animation.Status.RUNNING) {
                this.doShow();
            }
        };
    }

    protected ChangeListener<Animation.Status> createAnimationOutListener() {
        return (obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                this.doHide();
            }
        };
    }

    protected Timeline createCloseBlockedAnimation() {
        return Animations.zoomOut(((ModalPane)this.getSkinnable()).getContent(), Duration.millis((double)100.0), 0.98);
    }

    protected void show() {
        if (((ModalPane)this.getSkinnable()).getViewOrder() <= (double)((ModalPane)this.getSkinnable()).getTopViewOrder()) {
            return;
        }
        @Nullable Node content = ((ModalPane)this.getSkinnable()).getContent();
        if (content == null) {
            this.doShow();
            return;
        }
        if (this.inTransition == null && ((ModalPane)this.getSkinnable()).getInTransitionFactory() != null) {
            this.inTransition = ((ModalPane)this.getSkinnable()).getInTransitionFactory().apply(content);
            this.inTransition.statusProperty().addListener(this.animationInListener);
        }
        if (this.inTransition != null) {
            this.inTransition.playFromStart();
        } else {
            this.doShow();
        }
    }

    protected void hide() {
        if (((ModalPane)this.getSkinnable()).getViewOrder() >= 10.0) {
            return;
        }
        @Nullable Node content = ((ModalPane)this.getSkinnable()).getContent();
        if (content == null) {
            this.doHide();
            return;
        }
        if (this.outTransition == null && ((ModalPane)this.getSkinnable()).getOutTransitionFactory() != null) {
            this.outTransition = ((ModalPane)this.getSkinnable()).getOutTransitionFactory().apply(content);
            this.outTransition.statusProperty().addListener(this.animationOutListener);
        }
        if (this.outTransition != null) {
            this.outTransition.playFromStart();
        } else {
            this.doHide();
        }
    }

    protected void hideAndConsume(Event e) {
        this.hide();
        e.consume();
    }

    protected void doShow() {
        ((ModalPane)this.getSkinnable()).setDisplay(true);
        ((ModalPane)this.getSkinnable()).setOpacity(1.0);
        ((ModalPane)this.getSkinnable()).setViewOrder(((ModalPane)this.getSkinnable()).getTopViewOrder());
    }

    protected void doHide() {
        ((ModalPane)this.getSkinnable()).setOpacity(0.0);
        ((ModalPane)this.getSkinnable()).setViewOrder(10.0);
        ((ModalPane)this.getSkinnable()).setDisplay(false);
    }
}

