/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.SegmentedControlSkin;
import atlantafx.base.controls.ToggleLabel;
import java.util.Arrays;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.ToggleGroup;
import javafx.util.Duration;
import org.jetbrains.annotations.Nullable;

public class SegmentedControl
extends Control {
    protected static final Duration DEFAULT_ANIMATION_DURATION = Duration.millis((double)150.0);
    protected final ObservableList<ToggleLabel> segments = FXCollections.observableArrayList();
    protected final ObjectProperty<ToggleGroup> toggleGroup = new SimpleObjectProperty((Object)this, "toggleGroup", (Object)new ToggleGroup());
    protected final ObjectProperty<Duration> animationDuration = new SimpleObjectProperty((Object)this, "animationDuration", (Object)DEFAULT_ANIMATION_DURATION);

    public SegmentedControl() {
        this.getStyleClass().add((Object)"segmented-control");
        this.setFocusTraversable(false);
    }

    public SegmentedControl(String ... segments) {
        this();
        if (segments != null) {
            this.segments.setAll(Arrays.stream(segments).map(ToggleLabel::new).toList());
        }
    }

    public SegmentedControl(ToggleLabel ... segments) {
        this();
        if (segments != null) {
            this.segments.setAll((Object[])segments);
        }
    }

    public SegmentedControl(ObservableList<ToggleLabel> segments) {
        this();
        if (segments != null && !segments.isEmpty()) {
            this.segments.setAll(segments);
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new SegmentedControlSkin(this);
    }

    public final ObservableList<ToggleLabel> getSegments() {
        return this.segments;
    }

    public ObjectProperty<ToggleGroup> toggleGroupProperty() {
        return this.toggleGroup;
    }

    public ToggleGroup getToggleGroup() {
        return (ToggleGroup)this.toggleGroupProperty().getValue();
    }

    public void setToggleGroup(ToggleGroup toggleGroup) {
        this.toggleGroupProperty().setValue((Object)toggleGroup);
    }

    public ObjectProperty<Duration> animationDurationProperty() {
        return this.animationDuration;
    }

    public Duration getAnimationDuration() {
        return (Duration)this.animationDurationProperty().getValue();
    }

    public void setAnimationDuration(@Nullable Duration duration) {
        this.animationDurationProperty().setValue((Object)Objects.requireNonNullElse(duration, Duration.ZERO));
    }
}

