/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.BehaviorBase;
import atlantafx.base.controls.SegmentedControl;
import atlantafx.base.controls.SegmentedControlSkin;
import atlantafx.base.controls.ToggleLabel;
import java.util.List;
import java.util.Objects;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.Toggle;
import javafx.scene.input.KeyEvent;

public class SegmentedControlBehavior
extends BehaviorBase<SegmentedControl, SegmentedControlSkin> {
    public SegmentedControlBehavior(SegmentedControl control, SegmentedControlSkin skin) {
        super(control, skin);
        control.setOnKeyPressed(this::createKeyPressedListener);
    }

    protected void createKeyPressedListener(KeyEvent e) {
        if (e.getEventType() == KeyEvent.KEY_PRESSED) {
            switch (e.getCode()) {
                case UP: {
                    this.selectPrevious();
                    break;
                }
                case DOWN: {
                    this.selectNext();
                    break;
                }
                case LEFT: {
                    this.rtl((Node)this.getControl(), this::selectNext, this::selectPrevious);
                    break;
                }
                case RIGHT: {
                    this.rtl((Node)this.getControl(), this::selectPrevious, this::selectNext);
                    break;
                }
                case HOME: {
                    if (!((SegmentedControl)((Object)this.getControl())).isFocused() && !((SegmentedControl)((Object)this.getControl())).isFocusWithin()) break;
                    this.selectFirst();
                    break;
                }
                case END: {
                    if (!((SegmentedControl)((Object)this.getControl())).isFocused() && !((SegmentedControl)((Object)this.getControl())).isFocusWithin()) break;
                    this.selectLast();
                    break;
                }
                case TAB: {
                    if (e.isControlDown() && e.isShiftDown()) {
                        this.selectPrevious();
                        break;
                    }
                    if (!e.isControlDown()) break;
                    this.selectNext();
                }
            }
        }
        e.consume();
    }

    protected void rtl(Node node, Runnable rtlMethod, Runnable nonRtlMethod) {
        if (Objects.requireNonNull(node.getEffectiveNodeOrientation()) == NodeOrientation.RIGHT_TO_LEFT) {
            rtlMethod.run();
        } else {
            nonRtlMethod.run();
        }
    }

    protected List<ToggleLabel> getSegments() {
        return ((SegmentedControl)((Object)this.getControl())).getSegments();
    }

    protected int getSelectedIndex() {
        int n;
        Toggle toggle = ((SegmentedControl)((Object)this.getControl())).getToggleGroup().getSelectedToggle();
        if (toggle == null) {
            return -1;
        }
        if (toggle instanceof ToggleLabel) {
            ToggleLabel label = (ToggleLabel)toggle;
            n = this.getSegments().indexOf((Object)label);
        } else {
            n = -1;
        }
        return n;
    }

    public void selectFirst() {
        if (!this.getSegments().isEmpty()) {
            this.select((Toggle)((SegmentedControl)((Object)this.getControl())).getSegments().getFirst());
        }
    }

    public void selectLast() {
        if (!this.getSegments().isEmpty()) {
            this.select((Toggle)((SegmentedControl)((Object)this.getControl())).getSegments().getLast());
        }
    }

    public void selectPrevious() {
        if (this.getSegments().isEmpty()) {
            return;
        }
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex != 0) {
            this.select(this.getSegments().get(selectedIndex - 1));
        } else if (this.getSegments().size() > 1) {
            this.selectLast();
        }
    }

    public void selectNext() {
        if (this.getSegments().isEmpty()) {
            return;
        }
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex != this.getSegments().size() - 1) {
            this.select(this.getSegments().get(selectedIndex + 1));
        } else if (this.getSegments().size() > 1) {
            this.selectFirst();
        }
    }

    public void select(Toggle toggle) {
        if (!toggle.isSelected()) {
            toggle.setSelected(true);
        }
    }

    @Override
    public void dispose() {
        ((SegmentedControl)((Object)this.getControl())).setOnKeyPressed(null);
        super.dispose();
    }
}

