/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.BehaviorSkinBase;
import atlantafx.base.controls.SegmentedControl;
import atlantafx.base.controls.SegmentedControlBehavior;
import atlantafx.base.controls.ToggleLabel;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.util.Duration;

public class SegmentedControlSkin
extends BehaviorSkinBase<SegmentedControl, SegmentedControlBehavior> {
    protected final Pane rootContainer = new Pane();
    protected final Pane backgroundBox = new Pane();
    protected final HBox labelBox = new HBox();
    protected final Pane indicator = new Pane();
    protected final ListChangeListener<Node> segmentListener;
    protected final ChangeListener<Toggle> selectionListener;
    protected final ChangeListener<ToggleGroup> toggleGroupListener;
    protected boolean initialized = false;
    protected boolean animating = false;

    public SegmentedControlSkin(SegmentedControl control) {
        super(control);
        this.indicator.setMouseTransparent(true);
        this.indicator.getStyleClass().add((Object)"indicator");
        this.backgroundBox.getStyleClass().add((Object)"background");
        this.backgroundBox.getChildren().setAll((Object[])new Node[]{this.indicator});
        this.backgroundBox.setMouseTransparent(true);
        this.backgroundBox.prefWidthProperty().bind((ObservableValue)this.labelBox.widthProperty());
        this.backgroundBox.prefHeightProperty().bind((ObservableValue)this.labelBox.heightProperty());
        this.backgroundBox.paddingProperty().bind((ObservableValue)this.labelBox.paddingProperty());
        this.labelBox.getStyleClass().add((Object)"labels");
        this.rootContainer.getStyleClass().add((Object)"root-container");
        this.rootContainer.getChildren().setAll((Object[])new Node[]{this.backgroundBox, this.labelBox});
        this.getChildren().add((Object)this.rootContainer);
        this.segmentListener = change -> {
            while (change.next()) {
                for (Node node : change.getAddedSubList()) {
                    if (!(node instanceof Toggle)) continue;
                    Toggle toggle = (Toggle)node;
                    node.setOnMousePressed(e -> ((SegmentedControlBehavior)this.getBehavior()).select(toggle));
                    toggle.setToggleGroup(((SegmentedControl)this.getSkinnable()).getToggleGroup());
                }
                for (Node node : change.getRemoved()) {
                    this.disposeSegment(node);
                }
            }
            this.updateProperties();
        };
        this.labelBox.getChildren().addListener(this.segmentListener);
        this.selectionListener = (obs, old, val) -> {
            if (val instanceof ToggleLabel) {
                ToggleLabel label = (ToggleLabel)((Object)val);
                this.animateIndicator(label);
            }
        };
        control.getToggleGroup().selectedToggleProperty().addListener(this.selectionListener);
        this.toggleGroupListener = (obs, old, val) -> control.getSegments().forEach(btn -> btn.setToggleGroup((ToggleGroup)val));
        control.toggleGroupProperty().addListener(this.toggleGroupListener);
        Bindings.bindContent((List)this.labelBox.getChildren(), control.getSegments());
        if (!control.getSegments().isEmpty()) {
            ((ToggleLabel)((Object)control.getSegments().getFirst())).setSelected(true);
        }
    }

    @Override
    public SegmentedControlBehavior createDefaultBehavior() {
        return new SegmentedControlBehavior((SegmentedControl)this.getSkinnable(), this);
    }

    @Override
    public void dispose() {
        this.labelBox.getChildren().removeListener(this.segmentListener);
        ((SegmentedControl)this.getSkinnable()).getToggleGroup().selectedToggleProperty().removeListener(this.selectionListener);
        ((SegmentedControl)this.getSkinnable()).toggleGroupProperty().addListener(this.toggleGroupListener);
        Bindings.unbindContent((Object)this.labelBox.getChildren(), ((SegmentedControl)this.getSkinnable()).getSegments());
        this.getChildren().forEach(this::disposeSegment);
    }

    protected void animateIndicator(ToggleLabel dest) {
        Duration duration = ((SegmentedControl)this.getSkinnable()).getAnimationDuration();
        if (!this.initialized) {
            Platform.runLater(() -> this.moveIndicator(dest));
            this.initialized = true;
            return;
        }
        if (Duration.ZERO.equals((Object)duration)) {
            this.moveIndicator(dest);
            return;
        }
        this.animating = true;
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(((SegmentedControl)this.getSkinnable()).getAnimationDuration(), new KeyValue[]{new KeyValue((WritableValue)this.indicator.layoutXProperty(), (Object)dest.getLayoutX()), new KeyValue((WritableValue)this.indicator.layoutYProperty(), (Object)dest.getLayoutY()), new KeyValue((WritableValue)this.indicator.prefWidthProperty(), (Object)dest.getWidth()), new KeyValue((WritableValue)this.indicator.prefHeightProperty(), (Object)dest.getHeight())})});
        timeline.setOnFinished(event -> {
            this.moveIndicator(dest);
            this.animating = false;
        });
        timeline.play();
    }

    protected void moveIndicator(ToggleLabel dest) {
        if (dest.getLayoutX() == this.indicator.getLayoutX() && dest.getLayoutY() == this.indicator.getLayoutY() && dest.getWidth() == this.indicator.getWidth() && dest.getHeight() == this.indicator.getHeight()) {
            return;
        }
        this.indicator.setLayoutX(dest.getLayoutX());
        this.indicator.setLayoutY(dest.getLayoutY());
        this.indicator.setPrefWidth(dest.getWidth());
        this.indicator.setPrefHeight(dest.getHeight());
    }

    protected void updateProperties() {
        ObservableList<ToggleLabel> segments = ((SegmentedControl)this.getSkinnable()).getSegments();
        for (int i = 0; i < segments.size(); ++i) {
            ToggleLabel segment = (ToggleLabel)((Object)segments.get(i));
            segment.getProperties().put((Object)"index", (Object)i);
        }
    }

    protected void disposeSegment(Node node) {
        node.setOnMousePressed(null);
        node.getProperties().remove((Object)"index");
        if (node instanceof Toggle) {
            Toggle toggle = (Toggle)node;
            toggle.setToggleGroup(null);
        }
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        Toggle selected = ((SegmentedControl)this.getSkinnable()).getToggleGroup().getSelectedToggle();
        if (!this.animating && selected instanceof ToggleLabel) {
            ToggleLabel toggle = (ToggleLabel)selected;
            this.moveIndicator(toggle);
        }
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((SegmentedControl)this.getSkinnable()).prefWidth(height);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((SegmentedControl)this.getSkinnable()).prefHeight(width);
    }
}

