/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.util.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.PaintConverter;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.text.HitInfo;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.jetbrains.annotations.Nullable;

public class SelectableTextFlow
extends TextFlow {
    protected static final Predicate<Character> WORD_BOUNDARY_PREDICATE = c -> Character.isWhitespace(c.charValue()) || !Character.isAlphabetic(c.charValue()) && !Character.isDigit(c.charValue());
    protected final Selection selection = new Selection(this);
    protected int mouseDragStartPos = -1;
    protected final SimpleObjectProperty<ContextMenu> contextMenuProperty = new SimpleObjectProperty();
    protected final ObjectProperty<Paint> highlightTextFill = new StyleableObjectProperty<Paint>((Paint)Color.BLUE){

        public Object getBean() {
            return SelectableTextFlow.this;
        }

        public String getName() {
            return "highlightTextFill";
        }

        public CssMetaData<SelectableTextFlow, Paint> getCssMetaData() {
            return StyleableProperties.HIGHLIGHT_TEXT_FILL;
        }
    };
    protected final SimpleObjectProperty<Predicate<Character>> wordBoundaryPredicate = new SimpleObjectProperty((Object)this, "wordBoundaryPredicate", WORD_BOUNDARY_PREDICATE);
    private final BooleanProperty textSelectionOnMouseClick = new SimpleBooleanProperty((Object)this, "textSelectionOnMouseClick", false);

    public SelectableTextFlow() {
        this(null);
    }

    public SelectableTextFlow(Text ... children) {
        this.setCursor(Cursor.TEXT);
        this.setPrefWidth(Double.NEGATIVE_INFINITY);
        this.getStyleClass().add((Object)"selectable-text");
        this.initListeners();
        if (children != null) {
            this.setText(children);
        }
    }

    public final SimpleObjectProperty<ContextMenu> contextMenuProperty() {
        return this.contextMenuProperty;
    }

    public ContextMenu getContextMenu() {
        return (ContextMenu)this.contextMenuProperty.get();
    }

    public void setContextMenu(@Nullable ContextMenu contextMenu) {
        this.contextMenuProperty.set((Object)contextMenu);
    }

    public final ObjectProperty<Paint> highlightTextFillProperty() {
        return this.highlightTextFill;
    }

    public Paint getHighlightTextFill() {
        return (Paint)this.highlightTextFill.get();
    }

    public void setHighlightTextFill(Paint value) {
        this.highlightTextFill.set((Object)value);
    }

    public final SimpleObjectProperty<Predicate<Character>> wordBoundaryPredicateProperty() {
        return this.wordBoundaryPredicate;
    }

    public Predicate<Character> getWordBoundaryPredicate() {
        return (Predicate)this.wordBoundaryPredicateProperty().get();
    }

    public void setWordBoundaryPredicate(@Nullable Predicate<Character> wordBoundaryPredicate) {
        this.wordBoundaryPredicateProperty().set(Objects.requireNonNullElse(wordBoundaryPredicate, WORD_BOUNDARY_PREDICATE));
    }

    public final BooleanProperty textSelectionOnMouseClickProperty() {
        return this.textSelectionOnMouseClick;
    }

    public boolean getTextSelectionOnMouseClick() {
        return this.textSelectionOnMouseClickProperty().get();
    }

    public void setTextSelectionOnMouseClick(boolean textSelectionOnMouseClick) {
        this.textSelectionOnMouseClickProperty().set(textSelectionOnMouseClick);
    }

    public void setText(Text ... children) {
        this.getChildren().setAll((Object[])children);
    }

    public void clear() {
        this.getChildren().clear();
    }

    public String getContentAsString() {
        return this.getContent().toString();
    }

    public String getSelectedRangeAsString() {
        return this.selection.getSelectedRangeAsString();
    }

    public void selectAll() {
        this.clearSelection();
        int totalLength = this.getContentLength();
        if (totalLength > 0) {
            this.setSelectionPath();
            this.selection.select(0, totalLength + 1);
        }
    }

    public void selectRange(int fromInclusive, int toExclusive) {
        this.clearSelection();
        int totalLength = this.getContentLength();
        if (fromInclusive >= 0 && toExclusive <= totalLength + 1 && toExclusive > fromInclusive) {
            this.setSelectionPath();
            this.selection.select(fromInclusive, toExclusive);
        }
    }

    public void clearSelection() {
        this.selection.clear();
    }

    public void copySelectedRangeToClipboard() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString(this.getSelectedRangeAsString());
        clipboard.setContent((Map)content);
    }

    protected void initListeners() {
        this.getChildren().addListener(change -> {
            this.selection.clear();
            while (change.next()) {
                Text text;
                for (Node node : change.getAddedSubList()) {
                    if (!(node instanceof Text)) continue;
                    text = (Text)node;
                    text.selectionFillProperty().bind(this.highlightTextFillProperty());
                }
                for (Node node : change.getRemoved()) {
                    if (!(node instanceof Text)) continue;
                    text = (Text)node;
                    text.selectionFillProperty().unbind();
                }
            }
        });
        this.setOnMousePressed(e -> {
            Range wordRange;
            if (e.isPopupTrigger()) {
                this.showContextMenu((MouseEvent)e);
                return;
            }
            this.selection.clear();
            this.setSelectionPath();
            this.requestFocus();
            HitInfo hit = this.getHitInfo((MouseEvent)e);
            int charIndex = hit.getCharIndex();
            if (e.isPrimaryButtonDown() && e.getClickCount() == 1) {
                this.mouseDragStartPos = charIndex;
                return;
            }
            if (e.isPrimaryButtonDown() && e.getClickCount() == 2 && this.getTextSelectionOnMouseClick() && (wordRange = this.findWord(charIndex)) != null) {
                this.selection.select(wordRange);
            }
        });
        this.setOnMouseDragged(e -> {
            HitInfo hit = this.getHitInfo((MouseEvent)e);
            int charIndex = hit.getCharIndex();
            this.requestFocus();
            this.selection.select(Math.min(this.mouseDragStartPos, charIndex), Math.max(this.mouseDragStartPos, charIndex) + 1);
        });
        this.setOnMouseReleased(e -> {
            this.mouseDragStartPos = -1;
            if (e.isPopupTrigger()) {
                this.showContextMenu((MouseEvent)e);
            }
        });
        this.widthProperty().addListener((obs, old, val) -> this.selection.clear());
        this.heightProperty().addListener((obs, old, val) -> this.selection.clear());
    }

    protected HitInfo getHitInfo(MouseEvent e) {
        Point2D pos = new Point2D(e.getX(), e.getY());
        return this.hitTest(pos);
    }

    protected void setSelectionPath() {
        if (!this.getChildren().contains((Object)this.selection)) {
            this.getChildren().add((Object)this.selection);
        }
    }

    protected StringBuilder getContent() {
        StringBuilder sb = new StringBuilder();
        for (Node node : this.getChildren()) {
            if (!(node instanceof Text)) continue;
            Text text = (Text)node;
            sb.append(text.getText());
        }
        return sb;
    }

    protected int getContentLength() {
        int totalLength = 0;
        for (Node node : this.getChildren()) {
            if (!(node instanceof Text)) continue;
            Text text = (Text)node;
            totalLength += text.getText().length();
        }
        return totalLength;
    }

    protected void showContextMenu(MouseEvent e) {
        ContextMenu contextMenu = (ContextMenu)this.contextMenuProperty.get();
        if (contextMenu != null) {
            contextMenu.show((Node)this, e.getScreenX(), e.getScreenY());
        }
    }

    @Nullable
    protected Range findWord(int charIndex) {
        int i;
        String sb = this.getContentAsString();
        Predicate<Character> isBoundary = Objects.requireNonNull(this.getWordBoundaryPredicate());
        if (sb == null || sb.isEmpty() || charIndex < 0 || charIndex >= sb.length() || isBoundary.test(Character.valueOf(sb.charAt(charIndex)))) {
            return null;
        }
        int start = -1;
        int end = -1;
        for (i = charIndex; i >= 0; --i) {
            start = i;
            if (!isBoundary.test(Character.valueOf(sb.charAt(i)))) continue;
            ++start;
            break;
        }
        i = charIndex;
        while (i < sb.length() && !isBoundary.test(Character.valueOf(sb.charAt(i)))) {
            end = i++;
        }
        return start >= 0 && end > start ? new Range(start, end + 1) : null;
    }

    Selection getSelection() {
        return this.selection;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return SelectableTextFlow.getClassCssMetaData();
    }

    protected static class Selection
    extends Path {
        protected final SelectableTextFlow textFlow;
        protected int startPos = -1;
        protected int endPos = -1;

        public Selection(SelectableTextFlow textFlow) {
            this.textFlow = textFlow;
            this.setManaged(false);
            this.setViewOrder(100.0);
            this.getStyleClass().setAll((Object[])new String[]{"selection"});
        }

        public int getStartPos() {
            return this.startPos;
        }

        public int getEndPos() {
            return this.endPos;
        }

        public void select(Range range) {
            this.select(range.start(), range.end());
        }

        public void select(int fromInclusive, int toExclusive) {
            this.startPos = fromInclusive;
            this.endPos = toExclusive;
            Object[] selectionRange = this.textFlow.rangeShape(this.startPos, this.endPos);
            this.getElements().setAll(selectionRange);
            int totalLength = 0;
            for (Node node : this.textFlow.getChildren()) {
                if (!(node instanceof Text)) continue;
                Text text = (Text)node;
                int textLength = text.getText().length();
                int textStartPos = totalLength;
                if (this.startPos >= (totalLength += textLength)) continue;
                int textSelectionStart = Math.max(this.startPos - textStartPos, 0);
                int textSelectionEnd = Math.min(this.endPos - textStartPos, totalLength - textStartPos);
                if (textSelectionEnd > textSelectionStart) {
                    text.setSelectionStart(textSelectionStart);
                    text.setSelectionEnd(textSelectionEnd);
                }
                if (totalLength < this.endPos) continue;
                break;
            }
        }

        public String getSelectedRangeAsString() {
            StringBuilder sb = new StringBuilder();
            for (Node node : this.textFlow.getChildren()) {
                Text text;
                if (!(node instanceof Text) || (text = (Text)node).getSelectionStart() < 0 || text.getSelectionEnd() <= text.getSelectionStart()) continue;
                sb.append(text.getText(), Math.max(text.getSelectionStart(), 0), Math.min(text.getSelectionEnd(), text.getText().length()));
            }
            return sb.toString();
        }

        public void clear() {
            this.startPos = -1;
            this.endPos = -1;
            for (Node node : this.textFlow.getChildren()) {
                if (!(node instanceof Text)) continue;
                Text text = (Text)node;
                text.setSelectionStart(-1);
                text.setSelectionEnd(-1);
            }
            this.getElements().clear();
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<SelectableTextFlow, Paint> HIGHLIGHT_FILL = new CssMetaData<SelectableTextFlow, Paint>("-fx-highlight-fill", PaintConverter.getInstance(), (Paint)Color.TRANSPARENT){

            public boolean isSettable(SelectableTextFlow styleable) {
                return styleable.selection.fillProperty() == null || !styleable.selection.fillProperty().isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SelectableTextFlow styleable) {
                ObjectProperty val = styleable.selection.fillProperty();
                return (StyleableProperty)val;
            }
        };
        private static final CssMetaData<SelectableTextFlow, Paint> HIGHLIGHT_TEXT_FILL = new CssMetaData<SelectableTextFlow, Paint>("-fx-highlight-text-fill", PaintConverter.getInstance(), (Paint)Color.TRANSPARENT){

            public boolean isSettable(SelectableTextFlow styleable) {
                return styleable.highlightTextFillProperty() == null || !styleable.highlightTextFillProperty().isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SelectableTextFlow styleable) {
                ObjectProperty<Paint> val = styleable.highlightTextFillProperty();
                return (StyleableProperty)val;
            }
        };
        private static final CssMetaData<SelectableTextFlow, Paint> HIGHLIGHT_STROKE = new CssMetaData<SelectableTextFlow, Paint>("-fx-highlight-stroke", PaintConverter.getInstance(), (Paint)Color.TRANSPARENT){

            public boolean isSettable(SelectableTextFlow styleable) {
                return styleable.selection.strokeProperty() == null || !styleable.selection.strokeProperty().isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SelectableTextFlow styleable) {
                ObjectProperty val = styleable.selection.strokeProperty();
                return (StyleableProperty)val;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<SelectableTextFlow, Paint>> styleables = new ArrayList<CssMetaData<SelectableTextFlow, Paint>>(TextFlow.getClassCssMetaData());
            styleables.add(HIGHLIGHT_FILL);
            styleables.add(HIGHLIGHT_STROKE);
            styleables.add(HIGHLIGHT_TEXT_FILL);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

