/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.TabLine;
import atlantafx.base.shim.event.EventHandlerManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Tooltip;
import org.jetbrains.annotations.Nullable;

public class Tab
implements EventTarget,
Styleable {
    protected static final String DEFAULT_STYLE_CLASS = "tab";
    public static final EventType<Event> SELECTION_CHANGED_EVENT = new EventType(Event.ANY, "TAB_LINE$SELECTION_CHANGED_EVENT");
    public static final EventType<Event> CLOSED_EVENT = new EventType(Event.ANY, "TAB_LINE$TAB_CLOSED");
    public static final EventType<Event> TAB_CLOSE_REQUEST_EVENT = new EventType(Event.ANY, "TAB_LINE$TAB_CLOSE_REQUEST_EVENT");
    @Nullable
    protected StringProperty id;
    @Nullable
    protected StringProperty style;
    @Nullable
    protected ReadOnlyBooleanWrapper selected;
    @Nullable
    protected StringProperty text;
    @Nullable
    protected @Nullable ObjectProperty<@Nullable Node> graphic;
    @Nullable
    protected @Nullable ObjectProperty<@Nullable ContextMenu> contextMenu;
    @Nullable
    protected BooleanProperty pinned;
    @Nullable
    protected @Nullable ObjectProperty<@Nullable EventHandler<Event>> onSelectionChanged;
    @Nullable
    protected @Nullable ObjectProperty<@Nullable EventHandler<Event>> onClosed;
    @Nullable
    protected @Nullable ObjectProperty<@Nullable Tooltip> tooltip;
    @Nullable
    protected @Nullable ObjectProperty<@Nullable EventHandler<Event>> onCloseRequest;
    @Nullable
    private @Nullable ReadOnlyObjectWrapper<@Nullable TabLine> tabLine;
    protected static final Object USER_DATA_KEY = new Object();
    @Nullable
    protected ObservableMap<Object, Object> properties;
    protected final EventHandlerManager eventHandlerManager = new EventHandlerManager(this);
    protected final ObservableList<String> styleClass = FXCollections.observableArrayList();

    public Tab() {
        this(null, null, null);
    }

    public Tab(@Nullable String text) {
        this(null, text, null);
    }

    public Tab(@Nullable String id, @Nullable String text) {
        this(id, text, null);
    }

    public Tab(@Nullable String id, @Nullable String text, @Nullable Node graphic) {
        this.setId(id);
        this.setText(text);
        this.setGraphic(graphic);
        this.styleClass.addAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public final StringProperty idProperty() {
        if (this.id == null) {
            this.id = new SimpleStringProperty((Object)this, "id");
        }
        return this.id;
    }

    @Nullable
    public String getId() {
        return this.id != null ? (String)this.id.get() : null;
    }

    public void setId(@Nullable String value) {
        this.idProperty().set((Object)value);
    }

    public final StringProperty styleProperty() {
        if (this.style == null) {
            this.style = new SimpleStringProperty((Object)this, "style");
        }
        return this.style;
    }

    @Nullable
    public String getStyle() {
        return this.style != null ? (String)this.style.get() : null;
    }

    public void setStyle(@Nullable String value) {
        this.styleProperty().set((Object)value);
    }

    public final ReadOnlyBooleanProperty selectedProperty() {
        return this.selectedPropertyImpl().getReadOnlyProperty();
    }

    protected ReadOnlyBooleanWrapper selectedPropertyImpl() {
        if (this.selected == null) {
            this.selected = new ReadOnlyBooleanWrapper(){

                protected void invalidated() {
                    if (Tab.this.getOnSelectionChanged() != null) {
                        Event.fireEvent((EventTarget)Tab.this, (Event)new Event(SELECTION_CHANGED_EVENT));
                    }
                }

                public Object getBean() {
                    return Tab.this;
                }

                public String getName() {
                    return "selected";
                }
            };
        }
        return this.selected;
    }

    public boolean isSelected() {
        return this.selected != null && this.selected.get();
    }

    protected void updateSelected(boolean value) {
        this.selectedPropertyImpl().set(value);
    }

    public final StringProperty textProperty() {
        if (this.text == null) {
            this.text = new SimpleStringProperty((Object)this, "text");
        }
        return this.text;
    }

    @Nullable
    public String getText() {
        return this.text != null ? (String)this.text.get() : null;
    }

    public void setText(@Nullable String value) {
        this.textProperty().set((Object)value);
    }

    public final ObjectProperty<@Nullable Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new SimpleObjectProperty((Object)this, "graphic");
        }
        return this.graphic;
    }

    @Nullable
    public Node getGraphic() {
        return this.graphic != null ? (Node)this.graphic.get() : null;
    }

    public void setGraphic(@Nullable Node value) {
        this.graphicProperty().set((Object)value);
    }

    public final ObjectProperty<@Nullable ContextMenu> contextMenuProperty() {
        if (this.contextMenu == null) {
            this.contextMenu = new SimpleObjectProperty((Object)this, "contextMenu");
        }
        return this.contextMenu;
    }

    @Nullable
    public ContextMenu getContextMenu() {
        return this.contextMenu != null ? (ContextMenu)this.contextMenu.get() : null;
    }

    public void setContextMenu(@Nullable ContextMenu value) {
        this.contextMenuProperty().set((Object)value);
    }

    public final BooleanProperty pinnedProperty() {
        if (this.pinned == null) {
            this.pinned = new SimpleBooleanProperty(this, "pinned", false){

                protected void invalidated() {
                    if (Tab.this.getTabLine() != null && !Tab.this.getTabLine().getTabClosingPolicy().canPin(Tab.this)) {
                        Tab.this.setPinned(false);
                    }
                    super.invalidated();
                }
            };
        }
        return this.pinned;
    }

    public boolean isPinned() {
        return this.pinned != null && this.pinned.get();
    }

    public void setPinned(boolean value) {
        this.pinnedProperty().set(value);
    }

    public final ObjectProperty<@Nullable EventHandler<Event>> onSelectionChangedProperty() {
        if (this.onSelectionChanged == null) {
            this.onSelectionChanged = new ObjectPropertyBase<EventHandler<Event>>(){

                protected void invalidated() {
                    Tab.this.setEventHandler(SELECTION_CHANGED_EVENT, (EventHandler)this.get());
                }

                public Object getBean() {
                    return Tab.this;
                }

                public String getName() {
                    return "onSelectionChanged";
                }
            };
        }
        return this.onSelectionChanged;
    }

    @Nullable
    public EventHandler<Event> getOnSelectionChanged() {
        return this.onSelectionChanged != null ? (EventHandler)this.onSelectionChanged.get() : null;
    }

    public void setOnSelectionChanged(@Nullable EventHandler<Event> value) {
        this.onSelectionChangedProperty().set(value);
    }

    public final ObjectProperty<@Nullable EventHandler<Event>> onClosedProperty() {
        if (this.onClosed == null) {
            this.onClosed = new ObjectPropertyBase<EventHandler<Event>>(){

                protected void invalidated() {
                    Tab.this.setEventHandler(CLOSED_EVENT, (EventHandler)this.get());
                }

                public Object getBean() {
                    return Tab.this;
                }

                public String getName() {
                    return "onClosed";
                }
            };
        }
        return this.onClosed;
    }

    @Nullable
    public EventHandler<Event> getOnClosed() {
        return this.onClosed != null ? (EventHandler)this.onClosed.get() : null;
    }

    public void setOnClosed(@Nullable EventHandler<Event> value) {
        this.onClosedProperty().set(value);
    }

    public final ObjectProperty<@Nullable Tooltip> tooltipProperty() {
        if (this.tooltip == null) {
            this.tooltip = new SimpleObjectProperty((Object)this, "tooltip");
        }
        return this.tooltip;
    }

    @Nullable
    public Tooltip getTooltip() {
        return this.tooltip != null ? (Tooltip)this.tooltip.getValue() : null;
    }

    public void setTooltip(@Nullable Tooltip value) {
        this.tooltipProperty().setValue((Object)value);
    }

    public final ObjectProperty<@Nullable EventHandler<Event>> onCloseRequestProperty() {
        if (this.onCloseRequest == null) {
            this.onCloseRequest = new ObjectPropertyBase<EventHandler<Event>>(){

                protected void invalidated() {
                    Tab.this.setEventHandler(TAB_CLOSE_REQUEST_EVENT, (EventHandler)this.get());
                }

                public Object getBean() {
                    return Tab.this;
                }

                public String getName() {
                    return "onCloseRequest";
                }
            };
        }
        return this.onCloseRequest;
    }

    @Nullable
    public EventHandler<Event> getOnCloseRequest() {
        if (this.onCloseRequest == null) {
            return null;
        }
        return (EventHandler)this.onCloseRequest.get();
    }

    public void setOnCloseRequest(@Nullable EventHandler<Event> value) {
        this.onCloseRequestProperty().set(value);
    }

    public final ReadOnlyObjectProperty<@Nullable TabLine> tabLineProperty() {
        return this.tabLinePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<@Nullable TabLine> tabLinePropertyImpl() {
        if (this.tabLine == null) {
            this.tabLine = new ReadOnlyObjectWrapper((Object)this, "tabLine");
        }
        return this.tabLine;
    }

    @Nullable
    public TabLine getTabLine() {
        return this.tabLine != null ? (TabLine)((Object)this.tabLine.get()) : null;
    }

    protected void updateTabLine(@Nullable TabLine value) {
        this.tabLinePropertyImpl().set((Object)value);
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }

    public void setUserData(Object value) {
        this.getProperties().put(USER_DATA_KEY, value);
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain chain) {
        return chain.prepend((EventDispatcher)this.eventHandlerManager);
    }

    public final <E extends Event> void addEventHandler(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.addEventHandler(eventType, eventHandler);
    }

    public final <E extends Event> void removeEventHandler(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.removeEventHandler(eventType, eventHandler);
    }

    public final <E extends Event> void addEventFilter(EventType<E> eventType, EventHandler<? super E> eventFilter) {
        this.eventHandlerManager.addEventFilter(eventType, eventFilter);
    }

    public final <E extends Event> void removeEventFilter(EventType<E> eventType, EventHandler<? super E> eventFilter) {
        this.eventHandlerManager.removeEventFilter(eventType, eventFilter);
    }

    protected <E extends Event> void setEventHandler(EventType<E> eventType, @Nullable EventHandler<E> eventHandler) {
        this.eventHandlerManager.setEventHandler(eventType, eventHandler);
    }

    public String getTypeSelector() {
        return "Tab";
    }

    public ObservableList<String> getStyleClass() {
        return this.styleClass;
    }

    public final ObservableSet<PseudoClass> getPseudoClassStates() {
        return FXCollections.emptyObservableSet();
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Tab.getClassCssMetaData();
    }

    @Nullable
    public Styleable getStyleableParent() {
        return this.getTabLine();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Collections.emptyList();
    }

    public static class StretchingResizePolicy
    implements ResizePolicy {
        @Override
        public double computePrefWidth(double availableWidth, int tabCount, boolean isTabsFit) {
            return availableWidth / (double)tabCount;
        }

        @Override
        public boolean isScrollable() {
            return false;
        }
    }

    public static class AdaptiveResizePolicy
    implements ResizePolicy {
        @Override
        public double computePrefWidth(double availableWidth, int tabCount, boolean isTabsFit) {
            return isTabsFit ? -1.0 : availableWidth / (double)tabCount;
        }

        @Override
        public boolean isScrollable() {
            return false;
        }
    }

    public static class ComputedWidthResizePolicy
    implements ResizePolicy {
        @Override
        public double computePrefWidth(double availableWidth, int tabCount, boolean isTabsFit) {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public boolean isScrollable() {
            return true;
        }
    }

    public static class FixedWidthResizePolicy
    implements ResizePolicy {
        @Override
        public double computePrefWidth(double availableWidth, int tabCount, boolean isTabsFit) {
            return -1.0;
        }

        @Override
        public boolean isScrollable() {
            return true;
        }
    }

    public static interface ResizePolicy {
        public static final double USE_FIXED_SIZE = -1.0;
        public static final double USE_COMPUTED_SIZE = Double.NEGATIVE_INFINITY;
        public static final ResizePolicy FIXED_WIDTH = new FixedWidthResizePolicy();
        public static final ResizePolicy COMPUTED_WIDTH = new ComputedWidthResizePolicy();
        public static final ResizePolicy ADAPTIVE = new AdaptiveResizePolicy();
        public static final ResizePolicy STRETCH = new StretchingResizePolicy();

        public double computePrefWidth(double var1, int var3, boolean var4);

        public boolean isScrollable();
    }

    public static class NoTabsClosingPolicy
    implements ClosingPolicy {
        @Override
        public boolean canClose(Tab tab) {
            return false;
        }

        @Override
        public boolean canPin(Tab tab) {
            return false;
        }

        @Override
        public String getStyleClass() {
            return "no-tabs-closable";
        }
    }

    public static class SelectedTabClosingPolicy
    implements ClosingPolicy {
        @Override
        public boolean canClose(Tab tab) {
            return tab.isSelected();
        }

        @Override
        public boolean canPin(Tab tab) {
            return true;
        }

        @Override
        public String getStyleClass() {
            return "selected-tab-closable";
        }
    }

    public static class AllTabsClosingPolicy
    implements ClosingPolicy {
        @Override
        public boolean canClose(Tab tab) {
            return true;
        }

        @Override
        public boolean canPin(Tab tab) {
            return true;
        }

        @Override
        public String getStyleClass() {
            return "all-tabs-closable";
        }
    }

    public static interface ClosingPolicy {
        public static final ClosingPolicy ALL_TABS = new AllTabsClosingPolicy();
        public static final ClosingPolicy SELECTED_TAB = new SelectedTabClosingPolicy();
        public static final ClosingPolicy NO_TABS = new NoTabsClosingPolicy();

        public boolean canClose(Tab var1);

        public boolean canPin(Tab var1);

        public String getStyleClass();
    }

    public static enum DragPolicy {
        FIXED,
        REORDER;

    }
}

