/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.Tab;
import atlantafx.base.controls.TabLineSkin;
import atlantafx.base.shim.collections.ReorderableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Skin;
import javafx.util.Duration;
import org.jetbrains.annotations.Nullable;

public class TabLine
extends Control {
    protected static final Duration ANIMATION_SPEED = Duration.millis((double)150.0);
    protected static final double DEFAULT_TAB_FIXED_WIDTH = 120.0;
    protected static final double DEFAULT_TAB_MIN_WIDTH = 40.0;
    protected final ObservableList<Tab> tabs = new ReorderableList(new ArrayList());
    protected ObjectProperty<SingleSelectionModel<Tab>> selectionModel = new SimpleObjectProperty((Object)this, "selectionModel", (Object)new TabLineSelectionModel(this));
    @Nullable
    protected ObjectProperty<Tab.ClosingPolicy> tabClosingPolicy;
    @Nullable
    protected ObjectProperty<Tab.DragPolicy> tabDragPolicy;
    @Nullable
    protected ObjectProperty<Tab.ResizePolicy> tabResizePolicy;
    @Nullable
    protected BooleanProperty animated;
    @Nullable
    protected DoubleProperty tabFixedWidth;
    @Nullable
    protected DoubleProperty tabMinWidth;
    @Nullable
    protected ReadOnlyBooleanWrapper tabsFit;
    @Nullable
    protected StringProperty ellipsisString;
    private final ObjectProperty<@Nullable Node> leftNode = new SimpleObjectProperty((Object)this, "leftNode", null);
    private final ObjectProperty<@Nullable Node> rightNode = new SimpleObjectProperty((Object)this, "rightNode", null);

    public TabLine() {
        this(null);
    }

    public TabLine(Tab ... tabs) {
        this.setAccessibleRole(AccessibleRole.TAB_PANE);
        this.getStyleClass().setAll((Object[])new String[]{"tab-line"});
        if (tabs != null) {
            this.getTabs().addAll((Object[])tabs);
        }
    }

    public Skin<?> createDefaultSkin() {
        return new TabLineSkin(this);
    }

    public final ObservableList<Tab> getTabs() {
        return this.tabs;
    }

    public final ObjectProperty<SingleSelectionModel<Tab>> selectionModelProperty() {
        return this.selectionModel;
    }

    public SingleSelectionModel<Tab> getSelectionModel() {
        return (SingleSelectionModel)this.selectionModel.get();
    }

    public void setSelectionModel(@Nullable SingleSelectionModel<Tab> value) {
        this.selectionModel.set((Object)Objects.requireNonNullElse(value, new TabLineSelectionModel(this)));
    }

    public final ObjectProperty<Tab.ClosingPolicy> tabClosingPolicyProperty() {
        if (this.tabClosingPolicy == null) {
            this.tabClosingPolicy = new SimpleObjectProperty((Object)this, "tabClosingPolicy", (Object)Tab.ClosingPolicy.ALL_TABS);
        }
        return this.tabClosingPolicy;
    }

    public Tab.ClosingPolicy getTabClosingPolicy() {
        return (Tab.ClosingPolicy)this.tabClosingPolicyProperty().get();
    }

    public void setTabClosingPolicy(@Nullable Tab.ClosingPolicy value) {
        this.tabClosingPolicyProperty().set((Object)Objects.requireNonNullElse(value, Tab.ClosingPolicy.ALL_TABS));
    }

    public final ObjectProperty<Tab.DragPolicy> tabDragPolicyProperty() {
        if (this.tabDragPolicy == null) {
            this.tabDragPolicy = new SimpleObjectProperty((Object)this, "tabDragPolicy", (Object)Tab.DragPolicy.FIXED);
        }
        return this.tabDragPolicy;
    }

    public Tab.DragPolicy getTabDragPolicy() {
        return (Tab.DragPolicy)((Object)this.tabDragPolicyProperty().get());
    }

    public void setTabDragPolicy(@Nullable Tab.DragPolicy value) {
        this.tabDragPolicyProperty().set((Object)Objects.requireNonNullElse(value, Tab.DragPolicy.FIXED));
    }

    public final ObjectProperty<Tab.ResizePolicy> tabResizePolicyProperty() {
        if (this.tabResizePolicy == null) {
            this.tabResizePolicy = new SimpleObjectProperty((Object)this, "tabResizePolicy", (Object)Tab.ResizePolicy.COMPUTED_WIDTH);
        }
        return this.tabResizePolicy;
    }

    public Tab.ResizePolicy getTabResizePolicy() {
        return (Tab.ResizePolicy)this.tabResizePolicyProperty().get();
    }

    public void setTabResizePolicy(@Nullable Tab.ResizePolicy value) {
        this.tabResizePolicyProperty().set((Object)Objects.requireNonNullElse(value, Tab.ResizePolicy.COMPUTED_WIDTH));
    }

    public final BooleanProperty animatedProperty() {
        if (this.animated == null) {
            this.animated = new SimpleBooleanProperty((Object)this, "animated", true);
        }
        return this.animated;
    }

    public boolean getAnimated() {
        return this.animated == null || this.animatedProperty().get();
    }

    public void setAnimated(boolean value) {
        this.animatedProperty().set(value);
    }

    public final DoubleProperty tabFixedWidthProperty() {
        if (this.tabFixedWidth == null) {
            this.tabFixedWidth = new StyleableDoubleProperty(120.0){

                public CssMetaData<TabLine, Number> getCssMetaData() {
                    return StyleableProperties.TAB_FIXED_WIDTH;
                }

                public Object getBean() {
                    return TabLine.this;
                }

                public String getName() {
                    return "tabFixedWidth";
                }
            };
        }
        return this.tabFixedWidth;
    }

    public double getTabFixedWidth() {
        return this.tabFixedWidth != null ? this.tabFixedWidth.getValue() : 120.0;
    }

    public void setTabFixedWidth(double value) {
        this.tabFixedWidthProperty().setValue((Number)value);
    }

    public final DoubleProperty tabMinWidthProperty() {
        if (this.tabMinWidth == null) {
            this.tabMinWidth = new StyleableDoubleProperty(40.0){

                public CssMetaData<TabLine, Number> getCssMetaData() {
                    return StyleableProperties.TAB_MIN_WIDTH;
                }

                public Object getBean() {
                    return TabLine.this;
                }

                public String getName() {
                    return "tabMinWidth";
                }
            };
        }
        return this.tabMinWidth;
    }

    public double getTabMinWidth() {
        return this.tabMinWidth != null ? this.tabMinWidth.getValue() : 40.0;
    }

    public void setTabMinWidth(double value) {
        this.tabMinWidthProperty().setValue((Number)value);
    }

    public final ReadOnlyBooleanProperty tabsFitProperty() {
        return this.tabsFitPropertyImpl().getReadOnlyProperty();
    }

    protected ReadOnlyBooleanWrapper tabsFitPropertyImpl() {
        if (this.tabsFit == null) {
            this.tabsFit = new ReadOnlyBooleanWrapper((Object)this, "tabsFit", true);
        }
        return this.tabsFit;
    }

    public boolean isTabsFit() {
        return this.tabsFit != null && this.tabsFit.get();
    }

    protected void updateTabsFit(boolean value) {
        this.tabsFitPropertyImpl().set(value);
    }

    public final StringProperty ellipsisStringProperty() {
        if (this.ellipsisString == null) {
            this.ellipsisString = new SimpleStringProperty((Object)this, "ellipsisString", "");
        }
        return this.ellipsisString;
    }

    public String getEllipsisString() {
        return this.ellipsisString != null ? (String)this.ellipsisString.get() : "";
    }

    public void setEllipsisString(@Nullable String value) {
        this.ellipsisStringProperty().set((Object)Objects.requireNonNullElse(value, ""));
    }

    public final ObjectProperty<@Nullable Node> leftNodeProperty() {
        return this.leftNode;
    }

    @Nullable
    public Node getLeftNode() {
        return (Node)this.leftNode.getValue();
    }

    public void setLeftNode(@Nullable Node value) {
        this.leftNode.setValue((Object)value);
    }

    public final ObjectProperty<@Nullable Node> rightNodeProperty() {
        return this.rightNode;
    }

    public void setRightNode(@Nullable Node value) {
        this.rightNode.setValue((Object)value);
    }

    @Nullable
    public Node getRightNode() {
        return (Node)this.rightNode.getValue();
    }

    protected void pinOrUnpin(Tab tab) {
        Tab selectedTab = (Tab)this.getSelectionModel().getSelectedItem();
        int to = this.getIndexToMovePinedTab(tab);
        if (to >= 0) {
            this.getTabs().remove((Object)tab);
            this.getTabs().add(to, (Object)tab);
            if (selectedTab != null) {
                this.getSelectionModel().select((Object)selectedTab);
            }
        }
    }

    protected int getIndexToMovePinedTab(Tab tabToPin) {
        ObservableList<Tab> tabs = this.getTabs();
        if (tabs.isEmpty()) {
            return -1;
        }
        if (tabs.size() == 1) {
            return 0;
        }
        int lastPinnedTabIndex = -1;
        int lastTabIndex = tabs.size() - 1;
        int index = -1;
        for (Tab tab : tabs) {
            if (tab == tabToPin) continue;
            if (!tab.isPinned()) {
                lastPinnedTabIndex = index;
                break;
            }
            ++index;
        }
        if (lastPinnedTabIndex == -1) {
            return index == -1 ? 0 : lastTabIndex;
        }
        return Math.min(lastPinnedTabIndex + 1, lastTabIndex);
    }

    protected int getNextSelectedTabIndex(int start) {
        int min = 0;
        int max = this.getTabs().size();
        int index = start % max;
        if (index > min && max < min) {
            index = index + max - min;
        } else if (index < min && max > min) {
            index = index + max - min;
        }
        return index;
    }

    protected void reorderTabs(int fromIndex, int toIndex) {
        Tab fromTab = (Tab)this.getTabs().get(fromIndex);
        Tab toTab = (Tab)this.getTabs().get(toIndex);
        ObservableList<Tab> tabs = this.getTabs();
        if (!tabs.contains((Object)fromTab) || !tabs.contains((Object)toTab) || fromTab == toTab) {
            return;
        }
        if (tabs instanceof ReorderableList) {
            ReorderableList list = (ReorderableList)tabs;
            list.reorder(fromIndex, toIndex);
        } else {
            tabs.remove((Object)fromTab);
            tabs.add(toIndex, (Object)fromTab);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TabLine.getClassCssMetaData();
    }

    public static class TabLineSelectionModel
    extends SingleSelectionModel<Tab> {
        protected TabLine tabLine;
        protected final ListChangeListener<Tab> tabsListener = this::onTabsChange;

        public TabLineSelectionModel(TabLine tabLine) {
            this.tabLine = tabLine;
            tabLine.getTabs().addListener(this.tabsListener);
        }

        public void select(int index) {
            Tab tab = this.getModelItem(index);
            int size = this.getItemCount();
            int prevIndex = this.getSelectedIndex();
            if (index < 0 || size > 0 && index >= size || index == prevIndex && tab != null && tab.isSelected()) {
                return;
            }
            if (prevIndex >= 0 && prevIndex < size) {
                ((Tab)this.tabLine.getTabs().get(prevIndex)).updateSelected(false);
            }
            this.setSelectedIndex(index);
            if (tab != null) {
                this.setSelectedItem(tab);
            }
            if (this.getSelectedIndex() >= 0 && this.getSelectedIndex() < this.getItemCount()) {
                ((Tab)this.tabLine.getTabs().get(this.getSelectedIndex())).updateSelected(true);
            }
            this.tabLine.notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM);
        }

        public void select(Tab tab) {
            int size = this.getItemCount();
            for (int index = 0; index < size; ++index) {
                Tab item = this.getModelItem(index);
                if (item == null || !item.equals(tab)) continue;
                this.select(index);
                return;
            }
        }

        @Nullable
        protected Tab getModelItem(int index) {
            ObservableList<Tab> items = this.tabLine.getTabs();
            if (index < 0 || index >= items.size()) {
                return null;
            }
            return (Tab)items.get(index);
        }

        protected int getItemCount() {
            return this.tabLine.getTabs().size();
        }

        protected void onTabsChange(ListChangeListener.Change<? extends Tab> change) {
            while (change.next()) {
                for (Tab tab : change.getRemoved()) {
                    if (!tab.isSelected()) continue;
                    tab.updateSelected(false);
                    int index = change.getFrom();
                    this.selectNearestAvailableTab(index);
                }
                if (!change.wasAdded() && !change.wasRemoved() || this.getSelectedIndex() == this.tabLine.getTabs().indexOf(this.getSelectedItem())) continue;
                this.clearAndSelect(this.tabLine.getTabs().indexOf(this.getSelectedItem()));
            }
            if (this.getSelectedIndex() == -1 && this.getSelectedItem() == null && !this.tabLine.getTabs().isEmpty()) {
                this.selectNearestAvailableTab(0);
            } else if (this.tabLine.getTabs().isEmpty()) {
                this.clearSelection();
            }
        }

        protected void selectNearestAvailableTab(int tabIndex) {
            int size = this.getItemCount();
            int delta = 1;
            Tab bestTab = null;
            while (true) {
                Tab tmp;
                Tab tmp2;
                int downPos;
                if ((downPos = tabIndex - delta) >= 0 && (tmp2 = this.getModelItem(downPos)) != null) {
                    bestTab = tmp2;
                    break;
                }
                int upPos = tabIndex + delta - 1;
                if (upPos < size && (tmp = this.getModelItem(upPos)) != null) {
                    bestTab = tmp;
                    break;
                }
                if (downPos < 0 && upPos >= size) break;
                ++delta;
            }
            if (bestTab != null) {
                this.select(bestTab);
            }
        }

        protected void dispose() {
            this.tabLine.getTabs().removeListener(this.tabsListener);
            this.tabLine = null;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<TabLine, Number> TAB_FIXED_WIDTH = new CssMetaData<TabLine, Number>("-fx-tab-fixed-width", SizeConverter.getInstance(), (Number)120.0){

            public boolean isSettable(TabLine tabLine) {
                return tabLine.tabFixedWidth == null || !tabLine.tabFixedWidth.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(TabLine tabLine) {
                return (StyleableProperty)tabLine.tabFixedWidthProperty();
            }
        };
        private static final CssMetaData<TabLine, Number> TAB_MIN_WIDTH = new CssMetaData<TabLine, Number>("-fx-tab-min-width", SizeConverter.getInstance(), (Number)40.0){

            public boolean isSettable(TabLine tabLine) {
                return tabLine.tabMinWidth == null || !tabLine.tabMinWidth.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(TabLine tabLine) {
                return (StyleableProperty)tabLine.tabMinWidthProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<TabLine, Number>> styleables = new ArrayList<CssMetaData<TabLine, Number>>(Control.getClassCssMetaData());
            styleables.add(TAB_FIXED_WIDTH);
            styleables.add(TAB_MIN_WIDTH);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

