/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.BehaviorBase;
import atlantafx.base.controls.Tab;
import atlantafx.base.controls.TabLine;
import atlantafx.base.controls.TabLineSkin;
import java.util.Objects;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.SelectionModel;
import javafx.scene.input.KeyEvent;

public class TabLineBehavior
extends BehaviorBase<TabLine, TabLineSkin> {
    public TabLineBehavior(TabLine control, TabLineSkin skin) {
        super(control, skin);
        control.setOnKeyPressed(this::createKeyPressedListener);
        control.setOnMousePressed(e -> ((TabLine)((Object)((Object)this.getControl()))).requestFocus());
    }

    protected void createKeyPressedListener(KeyEvent e) {
        if (e.getEventType() == KeyEvent.KEY_PRESSED) {
            switch (e.getCode()) {
                case UP: {
                    this.selectPreviousTab();
                    break;
                }
                case DOWN: {
                    this.selectNextTab();
                    break;
                }
                case LEFT: {
                    this.rtl((Node)this.getControl(), this::selectNextTab, this::selectPreviousTab);
                    break;
                }
                case RIGHT: {
                    this.rtl((Node)this.getControl(), this::selectPreviousTab, this::selectNextTab);
                    break;
                }
                case HOME: {
                    if (!((TabLine)((Object)this.getControl())).isFocused()) break;
                    this.moveSelection(-1, 1);
                    break;
                }
                case END: {
                    if (!((TabLine)((Object)this.getControl())).isFocused()) break;
                    this.moveSelection(((TabLine)((Object)this.getControl())).getTabs().size(), -1);
                    break;
                }
                case TAB: {
                    if (e.isControlDown() && e.isShiftDown()) {
                        this.selectPreviousTab();
                        break;
                    }
                    if (!e.isControlDown()) break;
                    this.selectNextTab();
                }
            }
        }
    }

    protected void rtl(Node node, Runnable rtlMethod, Runnable nonRtlMethod) {
        if (Objects.requireNonNull(node.getEffectiveNodeOrientation()) == NodeOrientation.RIGHT_TO_LEFT) {
            rtlMethod.run();
        } else {
            nonRtlMethod.run();
        }
    }

    public void selectTab(Tab tab) {
        ((TabLine)((Object)this.getControl())).getSelectionModel().select((Object)tab);
    }

    public void selectPreviousTab() {
        this.moveSelection(-1);
    }

    public void selectNextTab() {
        this.moveSelection(1);
    }

    public void closeTab(Tab tab) {
        TabLine tabLine = (TabLine)((Object)this.getControl());
        int index = tabLine.getTabs().indexOf((Object)tab);
        if (index != -1) {
            tabLine.getTabs().remove(index);
        }
        if (tab.getOnClosed() != null) {
            Event.fireEvent((EventTarget)tab, (Event)new Event(Tab.CLOSED_EVENT));
        }
    }

    public boolean canCloseTab(Tab tab) {
        Event event = new Event((Object)tab, (EventTarget)tab, Tab.TAB_CLOSE_REQUEST_EVENT);
        Event.fireEvent((EventTarget)tab, (Event)event);
        return !event.isConsumed();
    }

    @Override
    public void dispose() {
        ((TabLine)((Object)this.getControl())).setOnKeyPressed(null);
        ((TabLine)((Object)this.getControl())).setOnMousePressed(null);
        super.dispose();
    }

    protected SelectionModel<Tab> getSelectionModel() {
        return ((TabLine)((Object)this.getControl())).getSelectionModel();
    }

    protected void moveSelection(int delta) {
        int start = this.getSelectionModel().getSelectedIndex();
        this.moveSelection(start, delta);
    }

    protected void moveSelection(int start, int delta) {
        if (((TabLine)((Object)this.getControl())).getTabs().isEmpty()) {
            return;
        }
        int index = ((TabLine)((Object)this.getControl())).getNextSelectedTabIndex(start + delta);
        if (index > -1) {
            this.getSelectionModel().select(index);
        }
        ((TabLine)((Object)this.getControl())).requestFocus();
    }
}

