/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.Tab;
import atlantafx.base.controls.TabLine;
import atlantafx.base.controls.TabLineBehavior;
import atlantafx.base.controls.TabSkin;
import atlantafx.base.controls.TabsContainer;
import java.util.List;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.SkinBase;
import javafx.scene.input.SwipeEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.shape.Rectangle;
import org.jetbrains.annotations.Nullable;

public class TabLineSkin
extends SkinBase<TabLine> {
    protected static final boolean IS_TOUCH_SUPPORTED = Platform.isSupported((ConditionalFeature)ConditionalFeature.INPUT_TOUCH);
    protected final HBox rootContainer = new HBox();
    protected final TabsContainer tabsContainer;
    protected final Rectangle clipRect;
    protected final TabLineBehavior behavior;
    protected final InvalidationListener selectionChangeListener = o -> ((TabLine)this.getSkinnable()).requestLayout();
    @Nullable
    protected SelectionModel<Tab> selectionModel;

    public TabLineSkin(TabLine control) {
        super((Control)control);
        this.rootContainer.getStyleClass().add((Object)"root-container");
        this.behavior = new TabLineBehavior(control, this);
        this.tabsContainer = new TabsContainer(control, this.behavior);
        HBox.setHgrow((Node)this.tabsContainer, (Priority)Priority.ALWAYS);
        this.clipRect = new Rectangle(control.getWidth(), control.getHeight());
        control.setClip((Node)this.clipRect);
        if (!control.getTabs().isEmpty()) {
            this.tabsContainer.addTabs((List<? extends Tab>)control.getTabs(), 0);
            this.tabsContainer.updatePseudoClasses();
        }
        if (control.getLeftNode() != null) {
            control.getLeftNode().getStyleClass().add((Object)"left-node");
            HBox.setHgrow((Node)control.getLeftNode(), (Priority)Priority.NEVER);
            this.rootContainer.getChildren().add((Object)control.getLeftNode());
        }
        this.rootContainer.getChildren().addAll((Object[])new Node[]{this.tabsContainer});
        if (control.getRightNode() != null) {
            control.getRightNode().getStyleClass().add((Object)"right-node");
            HBox.setHgrow((Node)control.getRightNode(), (Priority)Priority.NEVER);
            this.rootContainer.getChildren().add((Object)control.getRightNode());
        }
        this.getChildren().setAll((Object[])new Node[]{this.rootContainer});
        this.updateSelectionModel();
        this.registerChangeListener((ObservableValue)control.selectionModelProperty(), o -> this.updateSelectionModel());
        this.registerChangeListener((ObservableValue)control.widthProperty(), o -> {
            this.tabsContainer.invalidateScrollOffset();
            this.clipRect.setWidth(control.getWidth());
        });
        this.registerChangeListener((ObservableValue)control.heightProperty(), o -> {
            this.tabsContainer.invalidateScrollOffset();
            this.clipRect.setHeight(control.getHeight());
        });
        this.registerChangeListener((ObservableValue)control.ellipsisStringProperty(), o -> {
            for (Node node : this.tabsContainer.getChildrenUnmodifiable()) {
                ((TabSkin)node).updateEllipsisString();
            }
        });
        this.registerChangeListener((ObservableValue)control.leftNodeProperty(), o -> {
            Node node = control.getLeftNode();
            if (node == null) {
                this.rootContainer.getChildren().removeIf(c -> c.getStyleClass().contains((Object)"left-node"));
            } else {
                if (!node.getStyleClass().contains((Object)"left-node")) {
                    node.getStyleClass().add((Object)"left-node");
                }
                HBox.setHgrow((Node)control.getLeftNode(), (Priority)Priority.NEVER);
                this.rootContainer.getChildren().addFirst((Object)node);
            }
        });
        this.registerChangeListener((ObservableValue)control.rightNodeProperty(), o -> {
            Node node = control.getRightNode();
            if (node == null) {
                this.rootContainer.getChildren().removeIf(c -> c.getStyleClass().contains((Object)"right-node"));
            } else {
                if (!node.getStyleClass().contains((Object)"right-node")) {
                    node.getStyleClass().add((Object)"right-node");
                }
                HBox.setHgrow((Node)control.getRightNode(), (Priority)Priority.NEVER);
                this.rootContainer.getChildren().add((Object)node);
            }
        });
        Tab selectedTab = (Tab)control.getSelectionModel().getSelectedItem();
        int selectedIndex = control.getSelectionModel().getSelectedIndex();
        if (selectedTab == null && selectedIndex != -1) {
            control.getSelectionModel().select(selectedIndex);
            selectedTab = (Tab)control.getSelectionModel().getSelectedItem();
        }
        if (selectedTab == null) {
            control.getSelectionModel().selectFirst();
        }
        if (IS_TOUCH_SUPPORTED) {
            control.addEventHandler(SwipeEvent.SWIPE_LEFT, o -> this.behavior.selectNextTab());
            control.addEventHandler(SwipeEvent.SWIPE_RIGHT, o -> this.behavior.selectPreviousTab());
        }
    }

    protected void updateSelectionModel() {
        if (this.selectionModel != null) {
            this.selectionModel.selectedItemProperty().removeListener(this.selectionChangeListener);
            SelectionModel<Tab> selectionModel = this.selectionModel;
            if (selectionModel instanceof TabLine.TabLineSelectionModel) {
                TabLine.TabLineSelectionModel m = (TabLine.TabLineSelectionModel)selectionModel;
                m.dispose();
            }
        }
        this.selectionModel = ((TabLine)this.getSkinnable()).getSelectionModel();
        this.selectionModel.selectedItemProperty().addListener(this.selectionChangeListener);
    }

    public void dispose() {
        this.unregisterListChangeListeners(((TabLine)this.getSkinnable()).getTabs());
        this.unregisterChangeListeners((ObservableValue)((TabLine)this.getSkinnable()).selectionModelProperty());
        this.unregisterChangeListeners((ObservableValue)((TabLine)this.getSkinnable()).widthProperty());
        this.unregisterChangeListeners((ObservableValue)((TabLine)this.getSkinnable()).heightProperty());
        this.unregisterChangeListeners((ObservableValue)((TabLine)this.getSkinnable()).ellipsisStringProperty());
        this.tabsContainer.dispose();
        this.behavior.dispose();
        this.getChildren().remove((Object)this.tabsContainer);
        if (this.selectionModel != null) {
            this.selectionModel.selectedItemProperty().removeListener(this.selectionChangeListener);
            this.selectionModel = null;
        }
        super.dispose();
    }
}

