/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.Tab;
import atlantafx.base.controls.TabLine;
import atlantafx.base.util.Bindings;
import java.util.function.Function;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.StackPane;
import org.jetbrains.annotations.Nullable;

public class TabMenuButton
extends Button {
    protected final TabLine tabLine;
    protected final ContextMenu contextMenu = new ContextMenu();
    protected final ToggleGroup toggleGroup = new ToggleGroup();

    public TabMenuButton(TabLine tabLine) {
        this(tabLine, null);
    }

    public TabMenuButton(TabLine tabLine, @Nullable Function<Tab, MenuItem> mapper) {
        this.tabLine = tabLine;
        if (mapper == null) {
            mapper = this::createRadioMenuItemMapper;
        }
        StackPane icon = new StackPane();
        icon.getStyleClass().setAll((Object[])new String[]{"tab-menu-icon"});
        this.setGraphic((Node)icon);
        this.getStyleClass().addAll((Object[])new String[]{"flat", "tab-menu-button"});
        this.setOnAction(o -> {
            this.beforeShow();
            this.contextMenu.show((Node)this, Side.BOTTOM, 0.0, 0.0);
        });
        Bindings.bindContent(this.contextMenu.getItems(), tabLine.getTabs(), mapper);
    }

    protected void beforeShow() {
        for (MenuItem mi : this.contextMenu.getItems()) {
            if (!(mi instanceof RadioMenuItem)) continue;
            RadioMenuItem rmi = (RadioMenuItem)mi;
            Tab selectedTab = (Tab)this.tabLine.getSelectionModel().getSelectedItem();
            rmi.setSelected(selectedTab != null && mi.getUserData() != null && selectedTab.hashCode() == mi.getUserData().hashCode());
        }
    }

    protected RadioMenuItem createRadioMenuItemMapper(Tab tab) {
        RadioMenuItem mi = new RadioMenuItem(tab.getText());
        mi.setOnAction(o -> {
            if (tab.getTabLine() != null) {
                tab.getTabLine().getSelectionModel().select((Object)tab);
            }
        });
        mi.setUserData((Object)tab.hashCode());
        mi.setToggleGroup(this.toggleGroup);
        return mi;
    }
}

