/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.Tab;
import atlantafx.base.controls.TabContextMenu;
import atlantafx.base.controls.TabLine;
import atlantafx.base.controls.TabLineBehavior;
import atlantafx.base.controls.TabsContainer;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Subscription;
import org.jetbrains.annotations.Nullable;

public class TabSkin
extends StackPane {
    protected static final PseudoClass SELECTED_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"selected");
    protected static final PseudoClass PINNED_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"pinned");
    protected static final PseudoClass MIN_WIDTH_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"min-width-exceeded");
    protected final Tab tab;
    protected final TabLine control;
    protected final TabLineBehavior behavior;
    protected final HBox tabBox;
    protected final Label label;
    protected final CloseButton closeBtn;
    protected final Rectangle clip;
    protected final Subscription propertiesSubscription = Subscription.EMPTY;
    protected final ListChangeListener<String> styleClassListener = new ListChangeListener<String>(){

        public void onChanged(ListChangeListener.Change<? extends String> change) {
            TabSkin.this.getStyleClass().setAll(TabSkin.this.tab.getStyleClass());
        }
    };
    @Nullable
    protected Tooltip currentTooltip;
    protected boolean closing = false;
    protected TransitionState transitionState = TransitionState.NONE;
    @Nullable
    protected Timeline currentTransition;
    protected final DoubleProperty transitionProgress = new SimpleDoubleProperty(1.0){

        protected void invalidated() {
            TabSkin.this.requestLayout();
        }
    };

    public TabSkin(Tab tab, TabLine control, TabLineBehavior behavior) {
        this.tab = tab;
        this.control = control;
        this.behavior = behavior;
        this.clip = new Rectangle();
        this.setClip((Node)this.clip);
        this.label = new Label(tab.getText(), tab.getGraphic());
        this.label.getStyleClass().setAll((Object[])new String[]{"label"});
        this.label.setMaxWidth(Double.MAX_VALUE);
        this.label.setEllipsisString(control.getEllipsisString());
        HBox.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
        this.closeBtn = new CloseButton();
        this.closeBtn.setOnMousePressed(e -> {
            if (MouseButton.PRIMARY.equals((Object)e.getButton())) {
                if (tab.isPinned()) {
                    tab.setPinned(false);
                    control.pinOrUnpin(tab);
                } else {
                    this.closeTab();
                }
                e.consume();
            }
        });
        this.closeBtn.getStyleClass().setAll((Object[])new String[]{"close-button"});
        HBox.setHgrow((Node)this.closeBtn, (Priority)Priority.NEVER);
        this.tabBox = new HBox();
        this.tabBox.getStyleClass().add((Object)"tab-box");
        this.tabBox.setAlignment(Pos.CENTER_LEFT);
        this.tabBox.getChildren().addAll((Object[])new Node[]{this.label, this.closeBtn});
        this.propertiesSubscription.and(tab.selectedProperty().subscribe(o -> {
            Parent patt0$temp;
            this.requestLayout();
            this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS, tab.isSelected());
            if (this.getParent() != null && (patt0$temp = this.getParent()) instanceof TabsContainer) {
                TabsContainer container = (TabsContainer)patt0$temp;
                container.scrollToSelectedTab();
            }
        }));
        this.propertiesSubscription.and(tab.pinnedProperty().subscribe((old, val) -> {
            control.pinOrUnpin(tab);
            this.requestLayout();
            this.pseudoClassStateChanged(PINNED_PSEUDOCLASS, (boolean)val);
        }));
        this.propertiesSubscription.and(tab.textProperty().subscribe(o -> this.label.setText(tab.getText())));
        this.propertiesSubscription.and(tab.graphicProperty().subscribe(o -> this.label.setGraphic(tab.getGraphic())));
        this.propertiesSubscription.and(tab.tooltipProperty().subscribe(o -> this.updateTooltip(tab.getTooltip())));
        this.propertiesSubscription.and(tab.styleProperty().subscribe(o -> this.setStyle(tab.getStyle())));
        this.propertiesSubscription.and(control.tabFixedWidthProperty().subscribe(o -> {
            this.requestLayout();
            control.requestLayout();
        }));
        tab.getStyleClass().addListener(this.styleClassListener);
        this.setOnContextMenuRequested(e -> {
            ContextMenu cm = tab.getContextMenu();
            if (cm != null) {
                if (cm instanceof TabContextMenu) {
                    TabContextMenu tcm = (TabContextMenu)cm;
                    tcm.updateOwnerTab(tab);
                }
                cm.show((Node)this.tabBox, e.getScreenX(), e.getScreenY());
                e.consume();
            }
        });
        this.setOnMousePressed(e -> {
            ContextMenu cm;
            if ((MouseButton.MIDDLE.equals((Object)e.getButton()) || MouseButton.PRIMARY.equals((Object)e.getButton())) && (cm = tab.getContextMenu()) != null && cm.isShowing()) {
                cm.hide();
            }
            if (MouseButton.MIDDLE.equals((Object)e.getButton()) && this.isShowCloseButton()) {
                this.closeTab();
            }
            if (e.getButton().equals((Object)MouseButton.PRIMARY)) {
                behavior.selectTab(tab);
            }
        });
        this.updateTooltip(tab.getTooltip());
        this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS, tab.isSelected());
        this.pseudoClassStateChanged(PINNED_PSEUDOCLASS, tab.isPinned());
        this.setViewOrder(1.0);
        this.setId(tab.getId());
        this.setStyle(tab.getStyle());
        this.setAccessibleRole(AccessibleRole.TAB_ITEM);
        this.getStyleClass().setAll(tab.getStyleClass());
        this.getChildren().addAll((Object[])new Node[]{this.tabBox});
    }

    public Tab getTab() {
        return this.tab;
    }

    public TransitionState getTransitionState() {
        return this.transitionState;
    }

    public double getTransitionProgress() {
        return this.transitionProgress.get();
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void setClosing(boolean value) {
        this.closing = value;
    }

    public void dispose() {
        this.tab.getStyleClass().removeListener(this.styleClassListener);
        this.tab.updateTabLine(null);
        this.propertiesSubscription.unsubscribe();
        this.setOnContextMenuRequested(null);
        this.setOnMousePressed(null);
        this.closeBtn.setOnMousePressed(null);
        this.currentTooltip = null;
        this.currentTransition = null;
    }

    public void animateShow() {
        this.transitionState = TransitionState.SHOWING;
        this.transitionProgress.setValue((Number)0.0);
        this.setVisible(true);
        this.currentTransition = this.createTimeline(this, 1.0, () -> {
            this.transitionState = TransitionState.NONE;
            this.tabBox.requestLayout();
        });
        this.currentTransition.play();
    }

    public void animateHide(Runnable callback) {
        this.transitionState = TransitionState.HIDING;
        this.currentTransition = this.createTimeline(this, 0.0, callback);
        this.currentTransition.play();
    }

    public void stopAnimation() {
        Timeline timeline = this.currentTransition;
        if (timeline != null && timeline.getStatus() == Animation.Status.RUNNING) {
            timeline.getOnFinished().handle(null);
            timeline.stop();
            this.currentTransition = null;
        }
    }

    protected double computeMinWidth(double height) {
        return this.computePrefWidth(height);
    }

    protected double computePrefWidth(double height) {
        Tab.ClosingPolicy closingPolicy = this.control.getTabClosingPolicy();
        double width = this.snapSizeX(this.label.prefWidth(-1.0));
        if (closingPolicy.canClose(this.getTab())) {
            width += this.snapSizeX(this.closeBtn.prefWidth(-1.0)) + this.closeBtn.snappedLeftInset() + this.closeBtn.snappedRightInset();
        }
        return this.snapSizeX(width) + this.snappedLeftInset() + this.snappedRightInset();
    }

    protected double computePrefHeight(double width) {
        return this.snapSizeY(this.tabBox.prefHeight(width)) + this.snappedTopInset() + this.snappedBottomInset();
    }

    protected void layoutChildren() {
        double width = this.snapSizeX(this.getWidth()) - this.snappedRightInset() - this.snappedLeftInset();
        double height = this.snapSizeY(this.getHeight()) - this.snappedTopInset() - this.snappedBottomInset();
        this.tabBox.resize(width * this.transitionProgress.getValue(), height);
        this.tabBox.relocate(this.snappedLeftInset(), this.snappedTopInset());
    }

    protected void setWidth(double value) {
        super.setWidth(value);
        this.clip.setWidth(value);
    }

    protected void setHeight(double value) {
        super.setHeight(value);
        this.clip.setHeight(value);
    }

    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        return switch (attribute) {
            case AccessibleAttribute.TEXT -> {
                if (this.tab.getText() != null) {
                    yield this.tab.getText();
                }
                yield "";
            }
            case AccessibleAttribute.SELECTED -> this.control.getSelectionModel().getSelectedItem() == this.tab;
            default -> super.queryAccessibleAttribute(attribute, parameters);
        };
    }

    public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        if (action == AccessibleAction.REQUEST_FOCUS) {
            this.control.getSelectionModel().select((Object)this.tab);
        } else {
            super.executeAccessibleAction(action, parameters);
        }
    }

    protected void updateTooltip(@Nullable Tooltip tooltip) {
        if (this.currentTooltip != null) {
            Tooltip.uninstall((Node)this, (Tooltip)this.currentTooltip);
        }
        if (tooltip != null) {
            Tooltip.install((Node)this, (Tooltip)tooltip);
            this.currentTooltip = tooltip;
        }
    }

    protected void updateEllipsisString() {
        this.label.setEllipsisString(this.control.getEllipsisString());
    }

    protected boolean isShowCloseButton() {
        return this.control.getTabClosingPolicy().canClose(this.getTab());
    }

    protected void closeTab() {
        if (this.behavior.canCloseTab(this.tab)) {
            this.setOnMousePressed(null);
            this.closeBtn.setOnMousePressed(null);
            this.behavior.closeTab(this.tab);
        }
    }

    protected Timeline createTimeline(TabSkin tabSkin, double endValue, Runnable onFinished) {
        Timeline timeline = new Timeline();
        timeline.setCycleCount(1);
        KeyValue keyValue = new KeyValue((WritableValue)tabSkin.transitionProgress, (Object)endValue, Interpolator.LINEAR);
        timeline.getKeyFrames().clear();
        timeline.getKeyFrames().add((Object)new KeyFrame(TabLine.ANIMATION_SPEED, new KeyValue[]{keyValue}));
        timeline.setOnFinished(e -> onFinished.run());
        return timeline;
    }

    public static enum TransitionState {
        NONE,
        SHOWING,
        HIDING;

    }

    protected class CloseButton
    extends StackPane {
        protected final StackPane graphic = new StackPane();

        protected CloseButton() {
            this.graphic.getStyleClass().setAll((Object[])new String[]{"graphic"});
            this.getChildren().setAll((Object[])new Node[]{this.graphic});
            this.getStyleClass().setAll((Object[])new String[]{"close-button"});
            this.setAccessibleRole(AccessibleRole.BUTTON);
        }

        public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
            if (action == AccessibleAction.FIRE) {
                TabSkin.this.closeTab();
            } else {
                super.executeAccessibleAction(action, parameters);
            }
        }
    }
}

