/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.Tab;
import atlantafx.base.controls.TabLine;
import atlantafx.base.controls.TabLineBehavior;
import atlantafx.base.controls.TabSkin;
import atlantafx.base.controls.TabsDragHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.DoubleStream;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Pair;
import org.jetbrains.annotations.Nullable;

public class TabsContainer
extends StackPane {
    protected static final PseudoClass PSEUDO_CLASS_FIRST = PseudoClass.getPseudoClass((String)"first");
    protected static final PseudoClass PSEUDO_CLASS_LAST = PseudoClass.getPseudoClass((String)"last");
    protected final TabLine control;
    protected final TabLineBehavior behavior;
    protected final Rectangle headerClip;
    protected final ListChangeListener<Tab> tabsListener;
    protected final TabsDragHandler tabsDragHandler;
    protected final ChangeListener<Tab.ClosingPolicy> closingPolicyListener;
    protected final ChangeListener<Tab.ResizePolicy> resizePolicyListener;
    protected boolean measuringTabs = false;
    protected double scrollOffset;
    protected boolean scrollOffsetDirty = true;

    public TabsContainer(TabLine control, TabLineBehavior behavior) {
        this.control = control;
        this.behavior = behavior;
        this.headerClip = new Rectangle();
        this.setClip((Node)this.headerClip);
        this.tabsListener = this::onTabListChange;
        control.getTabs().addListener(this.tabsListener);
        this.getStyleClass().setAll((Object[])new String[]{"tabs", control.getTabClosingPolicy().getStyleClass()});
        this.tabsDragHandler = new TabsDragHandler(control, this, behavior);
        this.tabsDragHandler.init();
        this.addEventHandler(ScrollEvent.SCROLL, e -> {
            double delta = Math.abs(e.getDeltaY()) > Math.abs(e.getDeltaX()) ? e.getDeltaY() : e.getDeltaX();
            this.setScrollOffset(this.scrollOffset + delta);
        });
        this.closingPolicyListener = (obs, old, val) -> {
            if (old != null) {
                this.getStyleClass().remove((Object)old.getStyleClass());
            }
            if (val != null) {
                this.getStyleClass().add((Object)val.getStyleClass());
            }
            this.requestLayout();
        };
        this.resizePolicyListener = (obs, old, val) -> this.requestLayout();
        control.tabClosingPolicyProperty().addListener(this.closingPolicyListener);
        control.tabResizePolicyProperty().addListener(this.resizePolicyListener);
    }

    protected void dispose() {
        this.control.getTabs().removeListener(this.tabsListener);
        this.control.tabClosingPolicyProperty().removeListener(this.closingPolicyListener);
        this.control.tabResizePolicyProperty().removeListener(this.resizePolicyListener);
        new ArrayList<Node>((Collection<Node>)this.getChildren()).forEach(node -> ((TabSkin)((Object)node)).dispose());
        this.tabsDragHandler.dispose();
    }

    protected double computePrefWidth(double height) {
        return DoubleStream.of(this.computeTabsWidths()).sum() + this.snappedLeftInset() + this.snappedRightInset();
    }

    protected double computePrefHeight(double width) {
        double height = 0.0;
        for (Node node : this.getChildren()) {
            TabSkin tabSkin = (TabSkin)node;
            height = Math.max(height, tabSkin.prefHeight(width));
        }
        return this.snapSizeY(height) + this.snappedTopInset() + this.snappedBottomInset();
    }

    protected void layoutChildren() {
        boolean isTabsFit;
        double availableWidth = this.getWidth();
        boolean bl = isTabsFit = this.computeTabsPrefWidth() < availableWidth;
        if (isTabsFit) {
            this.setScrollOffset(0.0);
        } else {
            if (this.scrollOffsetDirty) {
                this.scrollOffsetDirty = false;
            }
            this.setScrollOffset(this.scrollOffset);
        }
        this.updateHeaderClip();
        double prefHeight = this.snapSizeY(this.prefHeight(-1.0));
        double[] widths = this.computeTabsWidths();
        ObservableList children = this.getChildrenUnmodifiable();
        double tabX = this.scrollOffset;
        for (int i = 0; i < children.size(); ++i) {
            TabSkin tabSkin = (TabSkin)((Object)children.get(i));
            double tabWidth = widths[i];
            double tabHeight = this.snapSizeY(tabSkin.prefHeight(-1.0));
            tabSkin.resize(tabWidth, tabHeight);
            double tabY = prefHeight - tabHeight - this.snappedBottomInset();
            if (this.tabsDragHandler.getDragState() != TabsDragHandler.DragState.REORDER || this.tabsDragHandler.isNotDragged(tabSkin)) {
                tabSkin.relocate(tabX, tabY);
            }
            tabSkin.pseudoClassStateChanged(TabSkin.MIN_WIDTH_PSEUDOCLASS, tabWidth < this.control.getTabMinWidth());
            tabX += tabWidth;
        }
    }

    protected void updateHeaderClip() {
        this.measuringTabs = true;
        double prefWidth = this.snapSizeX(this.prefWidth(-1.0));
        this.measuringTabs = false;
        double prefHeight = this.snapSizeY(this.prefHeight(-1.0));
        double clipWidth = Math.min(prefWidth, this.snapSizeX(this.getWidth()));
        this.headerClip.setX(0.0);
        this.headerClip.setY(0.0);
        this.headerClip.setWidth(clipWidth);
        this.headerClip.setHeight(prefHeight);
    }

    protected double computeTabsPrefWidth() {
        Tab.ResizePolicy resizePolicy = this.control.getTabResizePolicy();
        int tabCount = this.getChildrenUnmodifiable().size();
        double availableWidth = this.getWidth();
        double prefWidth = 0.0;
        for (Node node : this.getChildrenUnmodifiable()) {
            double tabWidth = this.normalizeWidth(resizePolicy.computePrefWidth(availableWidth, tabCount, true), node.prefWidth(-1.0));
            prefWidth += tabWidth;
        }
        return this.snapSizeX(prefWidth);
    }

    protected double[] computeTabsWidths() {
        Tab.ResizePolicy resizePolicy = this.control.getTabResizePolicy();
        int tabCount = this.getChildrenUnmodifiable().size();
        double availableWidth = this.getWidth();
        boolean isTabsFit = this.computeTabsPrefWidth() < availableWidth;
        this.control.updateTabsFit(isTabsFit);
        double[] widths = new double[tabCount];
        double constrainedWidth = 0.0;
        int i = 0;
        for (Node node : this.getChildrenUnmodifiable()) {
            TabSkin tabSkin = (TabSkin)node;
            double tabWidth = this.normalizeWidth(resizePolicy.computePrefWidth(availableWidth, tabCount, isTabsFit), tabSkin.prefWidth(-1.0));
            widths[i] = tabWidth = this.snapSizeX(tabWidth);
            constrainedWidth += tabWidth;
            ++i;
        }
        if (!resizePolicy.isScrollable() && constrainedWidth > availableWidth) {
            double delta = constrainedWidth - availableWidth;
            for (int k = widths.length - 1; k >= 0; --k) {
                widths[k] = widths[k] - 1.0;
                constrainedWidth -= 1.0;
                if ((delta -= 1.0) <= 0.0) break;
            }
        }
        return widths;
    }

    protected double normalizeWidth(double constrainedWidth, double contentWidth) {
        if (constrainedWidth == -1.0) {
            return this.control.getTabFixedWidth();
        }
        if (constrainedWidth == Double.NEGATIVE_INFINITY) {
            return contentWidth;
        }
        return constrainedWidth;
    }

    protected void setScrollOffset(double scrollOffset) {
        double availableWidth = this.snapSizeX(this.getWidth());
        double tabsWidth = DoubleStream.of(this.computeTabsWidths()).sum();
        double prevScrollOffset = this.scrollOffset;
        double newScrollOffset = scrollOffset;
        if (availableWidth - scrollOffset > tabsWidth && scrollOffset < 0.0) {
            newScrollOffset = availableWidth - tabsWidth;
        } else if (scrollOffset > 0.0) {
            newScrollOffset = 0.0;
        }
        if (Math.abs(newScrollOffset - prevScrollOffset) > 0.001) {
            this.scrollOffset = newScrollOffset;
            this.requestLayout();
        }
    }

    protected void scrollToSelectedTab() {
        double[] widths;
        int selectedTabIndex = this.control.getSelectionModel().getSelectedIndex();
        if (selectedTabIndex >= (widths = this.computeTabsWidths()).length) {
            return;
        }
        double availableWidth = this.snapSizeX(this.getWidth());
        double selectedTabStartX = 0.0;
        for (int i = 0; i < selectedTabIndex; ++i) {
            selectedTabStartX += widths[i];
        }
        double selectedTabEndX = selectedTabStartX + widths[selectedTabIndex];
        double newScrollOffset = this.scrollOffset;
        if (selectedTabStartX < -this.scrollOffset) {
            newScrollOffset = -selectedTabStartX;
        } else if (selectedTabEndX > availableWidth - this.scrollOffset) {
            newScrollOffset = availableWidth - selectedTabEndX;
        }
        this.setScrollOffset(newScrollOffset);
    }

    protected void invalidateScrollOffset() {
        this.scrollOffsetDirty = true;
    }

    protected void onTabListChange(ListChangeListener.Change<? extends Tab> change) {
        ArrayList tabsToRemove = new ArrayList();
        ArrayList tabsToAdd = new ArrayList();
        while (change.next()) {
            if (change.wasPermutated() && this.tabsDragHandler.getDragState() != TabsDragHandler.DragState.REORDER) {
                ObservableList<Tab> tabs = this.control.getTabs();
                ArrayList<Tab> permutatedTabs = new ArrayList<Tab>(change.getTo() - change.getFrom());
                for (int i = change.getFrom(); i < change.getTo(); ++i) {
                    permutatedTabs.add((Tab)tabs.get(i));
                }
                Tab prevSelectedTab = (Tab)this.control.getSelectionModel().getSelectedItem();
                this.control.getSelectionModel().clearSelection();
                this.removeTabs(permutatedTabs);
                this.addTabs(permutatedTabs, change.getFrom());
                this.control.getSelectionModel().select((Object)prevSelectedTab);
            }
            if (change.wasRemoved()) {
                tabsToRemove.addAll(change.getRemoved());
            }
            if (!change.wasAdded()) continue;
            tabsToAdd.addAll(change.getAddedSubList());
        }
        tabsToRemove.removeAll(tabsToAdd);
        this.removeTabs(tabsToRemove);
        ArrayList<Pair> tabsToMove = new ArrayList<Pair>();
        if (!tabsToAdd.isEmpty()) {
            for (Node node : new ArrayList(this.getChildren())) {
                int skinIndex;
                TabSkin tabSkin = (TabSkin)node;
                if (tabSkin.isClosing() || !tabsToAdd.contains(tabSkin.getTab())) continue;
                tabsToAdd.remove(tabSkin.getTab());
                int tabIndex = this.control.getTabs().indexOf((Object)tabSkin.getTab());
                if (tabIndex == (skinIndex = this.getChildren().indexOf((Object)tabSkin))) continue;
                tabsToMove.add(new Pair((Object)tabIndex, (Object)tabSkin));
            }
            if (!tabsToAdd.isEmpty()) {
                this.addTabs(tabsToAdd, this.control.getTabs().indexOf(tabsToAdd.getFirst()));
            }
            for (Pair move : tabsToMove) {
                this.doMoveTab((Integer)move.getKey(), (TabSkin)((Object)move.getValue()));
            }
        }
        this.updatePseudoClasses();
        this.control.requestLayout();
    }

    protected void updatePseudoClasses() {
        ObservableList children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            TabSkin tabSkin = (TabSkin)((Object)children.get(i));
            tabSkin.pseudoClassStateChanged(PSEUDO_CLASS_FIRST, i == 0);
            tabSkin.pseudoClassStateChanged(PSEUDO_CLASS_LAST, i == children.size() - 1);
        }
    }

    protected void addTabs(List<? extends Tab> addedList, int from) {
        for (Node node : new ArrayList(this.getChildren())) {
            TabSkin tabSkin = (TabSkin)node;
            if (tabSkin.getTransitionState() != TabSkin.TransitionState.HIDING) continue;
            this.stopCurrentAnimation(tabSkin.getTab());
        }
        int index = 0;
        for (Tab tab : addedList) {
            this.stopCurrentAnimation(tab);
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            this.doAddTab(new TabSkin(tab, this.control, this.behavior), from + index);
            ++index;
            tab.updateTabLine(this.control);
            TabSkin tabSkin = this.findTab(tab);
            if (tabSkin == null) continue;
            if (this.control.getAnimated()) {
                tabSkin.animateShow();
                continue;
            }
            tabSkin.setVisible(true);
            tabSkin.tabBox.requestLayout();
        }
    }

    protected void removeTabs(List<? extends Tab> removedList) {
        for (Tab tab : removedList) {
            this.stopCurrentAnimation(tab);
            TabSkin tabSkin = this.findTab(tab);
            if (tabSkin == null) continue;
            tabSkin.setClosing(true);
            tabSkin.dispose();
            Runnable cleanup = () -> {
                tabSkin.transitionState = TabSkin.TransitionState.NONE;
                this.doRemoveTab(tabToRemove);
                this.requestLayout();
                if (this.control.getTabs().isEmpty()) {
                    this.setVisible(false);
                }
            };
            if (this.control.getAnimated()) {
                tabSkin.animateHide(cleanup);
                continue;
            }
            cleanup.run();
        }
    }

    protected void doAddTab(TabSkin tabSkin, int addToIndex) {
        this.getChildren().add(addToIndex, (Object)tabSkin);
        this.invalidateScrollOffset();
    }

    protected void doRemoveTab(Tab tab) {
        TabSkin tabHeaderSkin = this.findTab(tab);
        if (tabHeaderSkin != null) {
            this.getChildren().remove((Object)tabHeaderSkin);
        }
        this.invalidateScrollOffset();
    }

    protected void doMoveTab(int moveToIndex, TabSkin tabSkin) {
        if (moveToIndex != this.getChildren().indexOf((Object)tabSkin)) {
            this.getChildren().remove((Object)tabSkin);
            this.getChildren().add(moveToIndex, (Object)tabSkin);
        }
        this.invalidateScrollOffset();
    }

    @Nullable
    protected TabSkin findTab(Tab tab) {
        for (Node node : this.getChildren()) {
            TabSkin tabSkin = (TabSkin)node;
            if (!tabSkin.getTab().equals(tab)) continue;
            return tabSkin;
        }
        return null;
    }

    protected void stopCurrentAnimation(Tab tab) {
        TabSkin tabSkin = this.findTab(tab);
        if (tabSkin != null) {
            tabSkin.stopAnimation();
        }
    }
}

