/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.Tab;
import atlantafx.base.controls.TabLine;
import atlantafx.base.controls.TabLineBehavior;
import atlantafx.base.controls.TabSkin;
import atlantafx.base.controls.TabsContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import org.jetbrains.annotations.Nullable;

public class TabsDragHandler {
    protected static final Duration DRAG_DURATION = Duration.millis((double)120.0);
    protected static final int DRAG_FORWARDS = 1;
    protected static final int DRAG_BACKWARDS = -1;
    protected static final double DRAG_DISTANCE_THRESHOLD = 0.75;
    protected final EventHandler<MouseEvent> tabDraggedHandler = this::handleTabDragged;
    protected final EventHandler<MouseEvent> tabMousePressedHandler = this::handleTabMousePressed;
    protected final EventHandler<MouseEvent> tabMouseReleasedHandler = this::handleTabMouseReleased;
    protected final DragTransition dragTransition = this.createDragTransition();
    protected final DragTransition dropTransition = this.createDropTransition();
    protected final ListChangeListener<Node> tabsDragListener = change -> {
        while (change.next()) {
            if (change.wasAdded()) {
                for (Node node : change.getAddedSubList()) {
                    this.addReorderEventHandlers(node);
                }
            }
            if (!change.wasRemoved()) continue;
            for (Node node : change.getRemoved()) {
                this.removeReorderEventHandlers(node);
            }
        }
    };
    protected final TabLine control;
    protected final TabsContainer tabsContainer;
    protected final TabLineBehavior behavior;
    protected final ChangeListener<Tab.DragPolicy> dragPolicyListener;
    @Nullable
    protected TabSkin dragTabSkin;
    @Nullable
    protected TabSkin dropTabSkin;
    @Nullable
    protected TabSkin transitionTabSkin;
    protected DragState dragState = DragState.NONE;
    protected double dragEventLocalX;
    protected int dragTabStartIndex;
    protected int dragTabCurrentIndex;
    protected int dragDirection = 1;
    protected double dragTabSourceX;
    protected double dragTabTransitionX;
    protected double dragTabDestX;
    protected double dropTabSourceX;
    protected double dropTabTransitionX;

    public TabsDragHandler(TabLine control, TabsContainer tabsContainer, TabLineBehavior behavior) {
        this.control = control;
        this.tabsContainer = tabsContainer;
        this.behavior = behavior;
        this.dragPolicyListener = (obs, old, val) -> this.updateDragListeners();
        control.tabDragPolicyProperty().addListener(this.dragPolicyListener);
    }

    public void init() {
        this.updateDragListeners();
    }

    public DragState getDragState() {
        return this.dragState;
    }

    public boolean isNotDragged(TabSkin tabSkin) {
        return tabSkin != this.dragTabSkin && tabSkin != this.transitionTabSkin;
    }

    public void dispose() {
        this.control.tabDragPolicyProperty().removeListener(this.dragPolicyListener);
        this.tabsContainer.getChildren().removeListener(this.tabsDragListener);
        new ArrayList<Node>((Collection<Node>)this.tabsContainer.getChildren()).forEach(this::removeReorderEventHandlers);
        this.dragTabSkin = null;
        this.dropTabSkin = null;
        this.transitionTabSkin = null;
    }

    protected DragTransition createDragTransition() {
        DragTransition transition = new DragTransition(frac -> {
            if (this.dragTabSkin != null) {
                this.dragTabSkin.setLayoutX(this.dragTabSourceX + this.dragTabTransitionX * frac);
            }
        });
        transition.setInterpolator(Interpolator.EASE_OUT);
        transition.setOnFinished(e -> {
            if (this.dragTabCurrentIndex != this.dragTabStartIndex) {
                this.reorderTabs(this.dragTabStartIndex, this.dragTabCurrentIndex);
            }
            this.resetDrag();
        });
        return transition;
    }

    protected DragTransition createDropTransition() {
        DragTransition transition = new DragTransition(frac -> {
            if (this.transitionTabSkin != null) {
                this.transitionTabSkin.setLayoutX(this.dropTabSourceX + this.dropTabTransitionX * frac);
            }
        });
        transition.setInterpolator(Interpolator.EASE_BOTH);
        transition.setOnFinished(e -> this.completeHeaderReordering());
        return transition;
    }

    protected void addReorderEventHandlers(Node node) {
        node.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.tabDraggedHandler);
        node.addEventHandler(MouseEvent.MOUSE_PRESSED, this.tabMousePressedHandler);
        node.addEventHandler(MouseEvent.MOUSE_RELEASED, this.tabMouseReleasedHandler);
    }

    protected void removeReorderEventHandlers(Node node) {
        node.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.tabDraggedHandler);
        node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.tabMousePressedHandler);
        node.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.tabMouseReleasedHandler);
    }

    protected void updateDragListeners() {
        switch (this.control.getTabDragPolicy()) {
            case FIXED: {
                for (Node node : this.tabsContainer.getChildren()) {
                    this.removeReorderEventHandlers(node);
                }
                this.tabsContainer.getChildren().removeListener(this.tabsDragListener);
                break;
            }
            case REORDER: {
                for (Node node : this.tabsContainer.getChildren()) {
                    this.addReorderEventHandlers(node);
                }
                this.tabsContainer.getChildren().addListener(this.tabsDragListener);
            }
        }
    }

    protected void handleTabDragged(MouseEvent event) {
        if (event.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.doDrag(event);
        }
    }

    protected void handleTabMousePressed(MouseEvent event) {
        if (event.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.startDrag(event);
        }
    }

    protected void handleTabMouseReleased(MouseEvent event) {
        if (event.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.stopDrag();
            event.consume();
        }
    }

    protected void startDrag(MouseEvent event) {
        this.stopTransition((Animation)this.dragTransition);
        this.stopTransition((Animation)this.dropTransition);
        this.dragTabSkin = (TabSkin)((Object)event.getSource());
        if (this.dragTabSkin != null) {
            this.dragState = DragState.START;
            this.dragTabStartIndex = this.dragTabCurrentIndex = this.tabsContainer.getChildren().indexOf((Object)this.dragTabSkin);
            this.dragEventLocalX = this.getEventLocalX(event);
            this.dragTabDestX = this.dragTabSkin.getLayoutX();
            this.dragTabSkin.setViewOrder(0.0);
        }
    }

    protected void doDrag(MouseEvent event) {
        double newLayoutX;
        if (this.dragState == DragState.NONE || this.dragTabSkin == null) {
            return;
        }
        double eventLocalX = this.getEventLocalX(event);
        double dragDelta = eventLocalX - this.dragEventLocalX;
        int direction = 0;
        if (dragDelta > 0.0) {
            direction = 1;
        } else if (dragDelta < 0.0) {
            direction = -1;
        }
        if (direction != 0 && this.dragDirection != direction) {
            this.stopTransition((Animation)this.dropTransition);
            this.dragDirection = direction;
        }
        if ((newLayoutX = this.dragTabSkin.getLayoutX() + dragDelta) >= 0.0 && newLayoutX + this.dragTabSkin.getWidth() <= this.tabsContainer.getWidth()) {
            this.dragState = DragState.REORDER;
            this.dragTabSkin.setLayoutX(newLayoutX);
            Bounds dragTabBounds = this.dragTabSkin.getBoundsInParent();
            if (direction == 1) {
                this.dragForwards(dragTabBounds);
            } else {
                this.dragBackwards(dragTabBounds);
            }
        }
        this.dragEventLocalX = eventLocalX;
        event.consume();
    }

    protected void dragForwards(Bounds dragTabBounds) {
        for (int i = this.dragTabCurrentIndex + 1; i < this.tabsContainer.getChildren().size(); ++i) {
            this.dropTabSkin = (TabSkin)((Object)this.tabsContainer.getChildren().get(i));
            if (this.transitionTabSkin == this.dropTabSkin) continue;
            Bounds dropTabBounds = this.dropTabSkin.getBoundsInParent();
            double draggedDistance = dragTabBounds.getMaxX() - dropTabBounds.getMinX();
            if (!(draggedDistance > dropTabBounds.getWidth() * 0.75)) break;
            this.stopTransition((Animation)this.dropTransition);
            this.dropTabTransitionX = -dragTabBounds.getWidth();
            this.dragTabDestX = dropTabBounds.getMaxX() - dragTabBounds.getWidth();
            this.startReorderingTransition();
        }
    }

    protected void dragBackwards(Bounds dragTabBounds) {
        for (int i = this.dragTabCurrentIndex - 1; i >= 0; --i) {
            this.dropTabSkin = (TabSkin)((Object)this.tabsContainer.getChildren().get(i));
            if (this.transitionTabSkin == this.dropTabSkin) continue;
            Bounds dropTabBounds = this.dropTabSkin.getBoundsInParent();
            double draggedDist = dropTabBounds.getMaxX() - dragTabBounds.getMinX();
            if (!(draggedDist > dropTabBounds.getWidth() * 0.75)) break;
            this.stopTransition((Animation)this.dropTransition);
            this.dropTabTransitionX = dragTabBounds.getWidth();
            this.dragTabDestX = dropTabBounds.getMinX();
            this.startReorderingTransition();
        }
    }

    protected void stopDrag() {
        if (this.dragState == DragState.START) {
            this.resetDrag();
        } else if (this.dragState == DragState.REORDER && this.dragTabSkin != null) {
            this.dragTabSourceX = this.dragTabSkin.getLayoutX();
            this.dragTabTransitionX = this.dragTabDestX - this.dragTabSourceX;
            this.dragTransition.playFromStart();
        }
        this.tabsContainer.invalidateScrollOffset();
    }

    protected void resetDrag() {
        this.dragState = DragState.NONE;
        if (this.dragTabSkin != null) {
            this.dragTabSkin.setViewOrder(1.0);
            this.dragTabSkin = null;
        }
        this.dropTabSkin = null;
        this.tabsContainer.requestLayout();
    }

    protected void startReorderingTransition() {
        this.transitionTabSkin = this.dropTabSkin;
        if (this.transitionTabSkin != null) {
            this.dropTabSourceX = this.transitionTabSkin.getLayoutX();
        }
        this.dropTransition.playFromStart();
    }

    protected void completeHeaderReordering() {
        if (this.transitionTabSkin != null) {
            this.tabsContainer.getChildren().remove((Object)this.transitionTabSkin);
            this.tabsContainer.getChildren().add(this.dragTabCurrentIndex, (Object)this.transitionTabSkin);
            this.transitionTabSkin = null;
            this.tabsContainer.requestLayout();
            this.dragTabCurrentIndex = this.tabsContainer.getChildren().indexOf((Object)this.dragTabSkin);
        }
    }

    protected void stopTransition(Animation animation) {
        if (animation.getStatus() == Animation.Status.RUNNING) {
            animation.getOnFinished().handle(null);
            animation.stop();
        }
    }

    protected double getEventLocalX(MouseEvent e) {
        Point2D sceneToLocalHR = this.tabsContainer.sceneToLocal(e.getSceneX(), e.getSceneY());
        return sceneToLocalHR.getX();
    }

    protected void reorderTabs(int from, int to) {
        Tab fromTab = (Tab)this.control.getTabs().get(from);
        this.control.reorderTabs(from, to);
        this.control.getSelectionModel().select((Object)fromTab);
    }

    protected static class DragTransition
    extends Transition {
        private final Consumer<Double> interpolate;

        public DragTransition(Consumer<Double> interpolate) {
            this.interpolate = interpolate;
            this.setCycleDuration(DRAG_DURATION);
        }

        protected void interpolate(double frac) {
            this.interpolate.accept(frac);
        }
    }

    public static enum DragState {
        NONE,
        START,
        REORDER;

    }
}

