/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.SlotListener;
import atlantafx.base.controls.TileBase;
import atlantafx.base.util.BBCodeParser;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;

public abstract class TileSkinBase<T extends TileBase>
extends SkinBase<T> {
    protected static final PseudoClass HAS_GRAPHIC = PseudoClass.getPseudoClass((String)"has-graphic");
    protected static final PseudoClass HAS_TITLE = PseudoClass.getPseudoClass((String)"has-title");
    protected static final PseudoClass HAS_DESCRIPTION = PseudoClass.getPseudoClass((String)"has-description");
    protected static final PseudoClass HAS_ACTION = PseudoClass.getPseudoClass((String)"has-action");
    protected final HBox container = new HBox();
    protected final StackPane graphicSlot = new StackPane();
    protected final ChangeListener<Node> graphicSlotListener;
    protected final VBox headerBox;
    protected final Label titleLbl;
    protected final TextFlow descriptionText;
    protected final StackPane actionSlot;
    protected final ChangeListener<Node> actionSlotListener;

    public TileSkinBase(T control) {
        super(control);
        this.graphicSlot.getStyleClass().add((Object)"graphic");
        this.graphicSlotListener = new SlotListener((Node)this.graphicSlot, (n, active) -> ((TileBase)this.getSkinnable()).pseudoClassStateChanged(HAS_GRAPHIC, (boolean)active));
        ((TileBase)((Object)control)).graphicProperty().addListener(this.graphicSlotListener);
        this.graphicSlotListener.changed(((TileBase)((Object)control)).graphicProperty(), null, (Object)((TileBase)((Object)control)).getGraphic());
        this.titleLbl = new Label(((TileBase)((Object)control)).getTitle());
        this.titleLbl.getStyleClass().add((Object)"title");
        this.titleLbl.setVisible(((TileBase)((Object)control)).getTitle() != null);
        this.titleLbl.setManaged(((TileBase)((Object)control)).getTitle() != null);
        this.descriptionText = new TextFlow();
        this.descriptionText.getStyleClass().add((Object)"description");
        this.descriptionText.setVisible(((TileBase)((Object)control)).getDescription() != null);
        this.descriptionText.setManaged(((TileBase)((Object)control)).getDescription() != null);
        this.setDescriptionText();
        this.headerBox = new VBox(new Node[]{this.titleLbl, this.descriptionText});
        this.headerBox.setFillWidth(true);
        this.headerBox.getStyleClass().add((Object)"header");
        HBox.setHgrow((Node)this.headerBox, (Priority)Priority.ALWAYS);
        this.headerBox.setMinHeight(-1.0);
        this.headerBox.setPrefHeight(-1.0);
        this.headerBox.setMaxHeight(-1.0);
        control.pseudoClassStateChanged(HAS_TITLE, ((TileBase)((Object)control)).getTitle() != null);
        this.registerChangeListener((ObservableValue)((TileBase)((Object)control)).titleProperty(), o -> {
            String value = ((TileBase)this.getSkinnable()).getTitle();
            this.titleLbl.setText(value);
            this.titleLbl.setVisible(value != null);
            this.titleLbl.setManaged(value != null);
            ((TileBase)this.getSkinnable()).pseudoClassStateChanged(HAS_TITLE, value != null);
        });
        control.pseudoClassStateChanged(HAS_DESCRIPTION, ((TileBase)((Object)control)).getDescription() != null);
        this.registerChangeListener((ObservableValue)((TileBase)((Object)control)).descriptionProperty(), o -> {
            String value = ((TileBase)this.getSkinnable()).getDescription();
            this.setDescriptionText();
            this.descriptionText.setVisible(value != null);
            this.descriptionText.setManaged(value != null);
            ((TileBase)this.getSkinnable()).pseudoClassStateChanged(HAS_DESCRIPTION, value != null);
        });
        this.actionSlot = new StackPane();
        this.actionSlot.getStyleClass().add((Object)"action");
        this.actionSlotListener = new SlotListener((Node)this.actionSlot, (n, active) -> ((TileBase)this.getSkinnable()).pseudoClassStateChanged(HAS_ACTION, (boolean)active));
        this.graphicSlot.setMinWidth(Double.NEGATIVE_INFINITY);
        this.actionSlot.setMinWidth(Double.NEGATIVE_INFINITY);
        this.descriptionText.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.descriptionText.setMinHeight(Double.NEGATIVE_INFINITY);
        this.container.setFillHeight(false);
        this.container.getChildren().setAll((Object[])new Node[]{this.graphicSlot, this.headerBox, this.actionSlot});
        this.container.getStyleClass().add((Object)"container");
        this.getChildren().setAll((Object[])new Node[]{this.container});
    }

    protected void setDescriptionText() {
        if (!this.descriptionText.getChildren().isEmpty()) {
            this.descriptionText.getChildren().clear();
        }
        if (((TileBase)this.getSkinnable()).getDescription() != null && !((TileBase)this.getSkinnable()).getDescription().isBlank()) {
            BBCodeParser.createLayout(((TileBase)this.getSkinnable()).getDescription(), this.descriptionText);
        }
    }

    protected double calcHeight() {
        double headerHeight = this.headerBox.getSpacing() + this.headerBox.getInsets().getTop() + this.headerBox.getInsets().getBottom() + this.titleLbl.getBoundsInLocal().getHeight() + (this.descriptionText.isManaged() ? this.descriptionText.getBoundsInLocal().getHeight() : 0.0);
        return Math.max(Math.max(this.graphicSlot.getHeight(), this.actionSlot.getHeight()), headerHeight) + this.container.getPadding().getTop() + this.container.getPadding().getBottom();
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.calcHeight();
    }

    public void dispose() {
        this.unregisterChangeListeners((ObservableValue)((TileBase)this.getSkinnable()).titleProperty());
        this.unregisterChangeListeners((ObservableValue)((TileBase)this.getSkinnable()).descriptionProperty());
        ((TileBase)this.getSkinnable()).graphicProperty().removeListener(this.graphicSlotListener);
        super.dispose();
    }
}

