/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.ToggleLabelSkin;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.css.PseudoClass;
import javafx.css.StyleableProperty;
import javafx.geometry.Pos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import javafx.scene.control.Skin;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;

public class ToggleLabel
extends Labeled
implements Toggle {
    public static final String INDEX_PROPERTY = "index";
    protected static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass((String)"selected");
    protected BooleanProperty selected;
    private ObjectProperty<ToggleGroup> toggleGroup;

    public ToggleLabel() {
        this.initialize();
    }

    public ToggleLabel(String text) {
        this.setText(text);
        this.initialize();
    }

    public ToggleLabel(String text, Node graphic) {
        this.setText(text);
        this.setGraphic(graphic);
        this.initialize();
    }

    protected void initialize() {
        this.getStyleClass().setAll((Object[])new String[]{"toggle-label"});
        this.setAccessibleRole(AccessibleRole.TAB_ITEM);
        ((StyleableProperty)this.alignmentProperty()).applyStyle(null, (Object)Pos.CENTER);
        this.setMnemonicParsing(true);
    }

    protected Skin<?> createDefaultSkin() {
        return new ToggleLabelSkin(this);
    }

    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        if (Objects.requireNonNull(attribute) == AccessibleAttribute.SELECTED) {
            return this.isSelected();
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    public int getIndex() {
        Object prop = this.getProperties().get((Object)INDEX_PROPERTY);
        if (prop instanceof Integer) {
            Integer index = (Integer)prop;
            return index;
        }
        return -1;
    }

    public final BooleanProperty selectedProperty() {
        if (this.selected == null) {
            this.selected = new BooleanPropertyBase(){

                protected void invalidated() {
                    boolean selected = this.get();
                    ToggleGroup group = ToggleLabel.this.getToggleGroup();
                    ToggleLabel.this.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, selected);
                    ToggleLabel.this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTED);
                    if (group != null) {
                        if (selected) {
                            group.selectToggle((Toggle)ToggleLabel.this);
                        } else if (group.getSelectedToggle() == ToggleLabel.this) {
                            if (!group.getSelectedToggle().isSelected()) {
                                for (Toggle toggle : group.getToggles()) {
                                    if (!toggle.isSelected()) continue;
                                    return;
                                }
                            }
                            group.selectToggle(null);
                        }
                    }
                }

                public Object getBean() {
                    return ToggleLabel.this;
                }

                public String getName() {
                    return "selected";
                }
            };
        }
        return this.selected;
    }

    public boolean isSelected() {
        return this.selected != null && this.selected.get();
    }

    public void setSelected(boolean selected) {
        this.selectedProperty().set(selected);
    }

    public final ObjectProperty<ToggleGroup> toggleGroupProperty() {
        if (this.toggleGroup == null) {
            this.toggleGroup = new ObjectPropertyBase<ToggleGroup>(){
                private ToggleGroup old;

                protected void invalidated() {
                    ToggleGroup tg = (ToggleGroup)this.get();
                    if (tg != null && !tg.getToggles().contains((Object)ToggleLabel.this)) {
                        if (this.old != null) {
                            this.old.getToggles().remove((Object)ToggleLabel.this);
                        }
                        tg.getToggles().add((Object)ToggleLabel.this);
                    } else if (tg == null) {
                        this.old.getToggles().remove((Object)ToggleLabel.this);
                    }
                    this.old = tg;
                }

                public Object getBean() {
                    return ToggleLabel.this;
                }

                public String getName() {
                    return "toggleGroup";
                }
            };
        }
        return this.toggleGroup;
    }

    public final void setToggleGroup(ToggleGroup value) {
        this.toggleGroupProperty().set((Object)value);
    }

    public final ToggleGroup getToggleGroup() {
        return this.toggleGroup == null ? null : (ToggleGroup)this.toggleGroup.get();
    }
}

