/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.ToggleSwitch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.TranslateTransition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.geometry.HorizontalDirection;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class ToggleSwitchSkin
extends SkinBase<ToggleSwitch> {
    protected static final Duration DEFAULT_ANIMATION_TIME = Duration.millis((double)200.0);
    protected final StackPane thumb = new StackPane();
    protected final StackPane thumbArea;
    protected final Label label;
    protected final StackPane labelContainer;
    protected final TranslateTransition transition;
    private DoubleProperty thumbMoveAnimationTime = null;

    public ToggleSwitchSkin(ToggleSwitch control) {
        super((Control)control);
        this.thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
        this.thumbArea = new StackPane();
        this.thumbArea.getStyleClass().setAll((Object[])new String[]{"thumb-area"});
        this.label = new Label();
        this.labelContainer = new StackPane();
        this.labelContainer.getStyleClass().add((Object)"label-container");
        this.transition = new TranslateTransition(DEFAULT_ANIMATION_TIME, (Node)this.thumb);
        this.transition.setFromX(0.0);
        this.label.textProperty().bind((ObservableValue)control.textProperty());
        this.label.graphicProperty().bind((ObservableValue)control.graphicProperty());
        this.label.alignmentProperty().bind((ObservableValue)control.alignmentProperty());
        StackPane.setAlignment((Node)this.label, (Pos)Pos.CENTER_LEFT);
        this.labelContainer.getChildren().addAll((Object[])new Node[]{this.label});
        this.getChildren().addAll((Object[])new Node[]{this.labelContainer, this.thumbArea, this.thumb});
        this.label.setOnMouseReleased(event -> this.mousePressedOnToggleSwitch(control));
        this.thumbArea.setOnMouseReleased(event -> this.mousePressedOnToggleSwitch(control));
        this.thumb.setOnMouseReleased(event -> this.mousePressedOnToggleSwitch(control));
        control.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue() != oldValue.booleanValue()) {
                this.selectedStateChanged();
            }
        });
    }

    protected void selectedStateChanged() {
        this.transition.stop();
        if (((ToggleSwitch)this.getSkinnable()).isSelected()) {
            this.transition.setRate(1.0);
            this.transition.jumpTo(Duration.ZERO);
        } else {
            this.transition.setRate(-1.0);
            this.transition.jumpTo(this.transition.getDuration());
        }
        this.transition.play();
    }

    private void mousePressedOnToggleSwitch(ToggleSwitch toggleSwitch) {
        toggleSwitch.setSelected(!toggleSwitch.isSelected());
    }

    private DoubleProperty thumbMoveAnimationTimeProperty() {
        if (this.thumbMoveAnimationTime == null) {
            this.thumbMoveAnimationTime = new StyleableDoubleProperty(DEFAULT_ANIMATION_TIME.toMillis()){

                public Object getBean() {
                    return ToggleSwitchSkin.this;
                }

                public String getName() {
                    return "thumbMoveAnimationTime";
                }

                protected void invalidated() {
                    ToggleSwitchSkin.this.transition.setDuration(Duration.millis((double)this.getValue()));
                }

                public CssMetaData<ToggleSwitch, Number> getCssMetaData() {
                    return StyleableProperties.THUMB_MOVE_ANIMATION_TIME;
                }
            };
        }
        return this.thumbMoveAnimationTime;
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        ToggleSwitch c = (ToggleSwitch)this.getSkinnable();
        double thumbWidth = this.snapSizeX(this.thumb.prefWidth(-1.0));
        double thumbHeight = this.snapSizeX(this.thumb.prefHeight(-1.0));
        this.thumb.resize(thumbWidth, thumbHeight);
        double thumbAreaWidth = this.snapSizeX(this.thumbArea.prefWidth(-1.0));
        double thumbAreaHeight = this.snapSizeX(this.thumbArea.prefHeight(-1.0));
        double thumbAreaY = this.snapPositionX(contentY + contentHeight / 2.0 - thumbAreaHeight / 2.0);
        double labelWidth = this.label.getText() != null && !this.label.getText().isEmpty() || this.label.getGraphic() != null ? contentWidth - thumbAreaWidth : 0.0;
        double labelX = c.getLabelPosition() == HorizontalDirection.RIGHT ? thumbAreaWidth : 0.0;
        double thumbAreaX = c.getLabelPosition() == HorizontalDirection.RIGHT ? 0.0 : labelWidth;
        this.thumbArea.resize(thumbAreaWidth, thumbAreaHeight);
        this.thumbArea.setLayoutX(thumbAreaX);
        this.thumbArea.setLayoutY(thumbAreaY);
        this.labelContainer.resize(labelWidth, thumbAreaHeight);
        this.labelContainer.setLayoutX(labelX);
        this.labelContainer.setLayoutY(thumbAreaY);
        this.thumb.setLayoutX(this.thumbArea.getLayoutX());
        this.thumb.setLayoutY(thumbAreaY + (thumbAreaHeight - thumbHeight) / 2.0);
        double thumbTarget = thumbAreaWidth - thumbWidth;
        this.transition.setToX(thumbTarget);
        if (this.transition.getStatus() == Animation.Status.RUNNING) {
            Duration currentTime = this.transition.getCurrentTime();
            this.transition.stop();
            this.transition.playFrom(currentTime);
        } else {
            this.thumb.setTranslateX(c.isSelected() ? thumbTarget : 0.0);
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.label.prefWidth(-1.0) + this.thumbArea.prefWidth(-1.0) + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + Math.max(this.thumb.prefHeight(-1.0), this.label.prefHeight(-1.0)) + bottomInset;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.label.prefWidth(-1.0) + 1.0 + this.thumbArea.prefWidth(-1.0) + rightInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computeMinHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ToggleSwitch)this.getSkinnable()).prefWidth(height);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ToggleSwitch)this.getSkinnable()).prefHeight(width);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    static class StyleableProperties {
        private static final CssMetaData<ToggleSwitch, Number> THUMB_MOVE_ANIMATION_TIME = new CssMetaData<ToggleSwitch, Number>("-fx-thumb-move-animation-time", SizeConverter.getInstance(), (Number)DEFAULT_ANIMATION_TIME.toMillis()){

            public boolean isSettable(ToggleSwitch toggleSwitch) {
                ToggleSwitchSkin skin = (ToggleSwitchSkin)toggleSwitch.getSkin();
                return skin.thumbMoveAnimationTime == null || !skin.thumbMoveAnimationTime.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(ToggleSwitch toggleSwitch) {
                ToggleSwitchSkin skin = (ToggleSwitchSkin)toggleSwitch.getSkin();
                return (StyleableProperty)skin.thumbMoveAnimationTimeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<ToggleSwitch, Number>> styleables = new ArrayList<CssMetaData<ToggleSwitch, Number>>(SkinBase.getClassCssMetaData());
            styleables.add(THUMB_MOVE_ANIMATION_TIME);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

