/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.shim.collections;

import java.util.IdentityHashMap;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ObservableListBase;
import javafx.util.Callback;

final class ElementObserver<E> {
    private Callback<E, Observable[]> extractor;
    private final Callback<E, InvalidationListener> listenerGenerator;
    private final ObservableListBase<E> list;
    private IdentityHashMap<E, ElementsMapElement> elementsMap = new IdentityHashMap();

    ElementObserver(Callback<E, Observable[]> extractor, Callback<E, InvalidationListener> listenerGenerator, ObservableListBase<E> list) {
        this.extractor = extractor;
        this.listenerGenerator = listenerGenerator;
        this.list = list;
    }

    void attachListener(E e) {
        if (this.elementsMap != null && e != null) {
            if (this.elementsMap.containsKey(e)) {
                this.elementsMap.get(e).increment();
            } else {
                InvalidationListener listener = (InvalidationListener)this.listenerGenerator.call(e);
                for (Observable o : (Observable[])this.extractor.call(e)) {
                    o.addListener(listener);
                }
                this.elementsMap.put(e, new ElementsMapElement(listener));
            }
        }
    }

    void detachListener(E e) {
        if (this.elementsMap != null && e != null) {
            ElementsMapElement el = this.elementsMap.get(e);
            for (Observable o : (Observable[])this.extractor.call(e)) {
                o.removeListener(el.getListener());
            }
            if (el.decrement() == 0) {
                this.elementsMap.remove(e);
            }
        }
    }

    private static class ElementsMapElement {
        InvalidationListener listener;
        int counter;

        public ElementsMapElement(InvalidationListener listener) {
            this.listener = listener;
            this.counter = 1;
        }

        public void increment() {
            ++this.counter;
        }

        public int decrement() {
            return --this.counter;
        }

        private InvalidationListener getListener() {
            return this.listener;
        }
    }
}

