/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.shim.collections;

import atlantafx.base.shim.collections.ElementObserver;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ModifiableObservableListBase;
import javafx.util.Callback;

public class ObservableListWrapper<E>
extends ModifiableObservableListBase<E>
implements RandomAccess {
    private final List<E> backingList;
    private final ElementObserver<E> elementObserver;

    public ObservableListWrapper(List<E> list) {
        this.backingList = list;
        this.elementObserver = null;
    }

    public ObservableListWrapper(List<E> list, Callback<E, Observable[]> extractor) {
        this.backingList = list;
        this.elementObserver = new ElementObserver<E>(extractor, new Callback<E, InvalidationListener>(){

            public InvalidationListener call(final E e) {
                return new InvalidationListener(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void invalidated(Observable observable) {
                        this.this$1.ObservableListWrapper.this.beginChange();
                        int size = this.this$1.ObservableListWrapper.this.size();
                        for (int i = 0; i < size; ++i) {
                            if (this.this$1.ObservableListWrapper.this.get(i) != e) continue;
                            this.this$1.ObservableListWrapper.this.nextUpdate(i);
                        }
                        this.this$1.ObservableListWrapper.this.endChange();
                    }
                };
            }
        }, this);
        int sz = this.backingList.size();
        for (int i = 0; i < sz; ++i) {
            this.elementObserver.attachListener(this.backingList.get(i));
        }
    }

    public E get(int index) {
        return this.backingList.get(index);
    }

    public int size() {
        return this.backingList.size();
    }

    protected void doAdd(int index, E element) {
        Objects.checkIndex(index, this.size() + 1);
        if (this.elementObserver != null) {
            this.elementObserver.attachListener(element);
        }
        this.backingList.add(index, element);
    }

    protected E doSet(int index, E element) {
        E removed = this.backingList.set(index, element);
        if (this.elementObserver != null) {
            this.elementObserver.detachListener(removed);
            this.elementObserver.attachListener(element);
        }
        return removed;
    }

    protected E doRemove(int index) {
        E removed = this.backingList.remove(index);
        if (this.elementObserver != null) {
            this.elementObserver.detachListener(removed);
        }
        return removed;
    }

    public int indexOf(Object o) {
        return this.backingList.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.backingList.lastIndexOf(o);
    }

    public boolean contains(Object o) {
        return this.backingList.contains(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.backingList.containsAll(c);
    }

    public void clear() {
        if (this.elementObserver != null) {
            int sz = this.size();
            for (int i = 0; i < sz; ++i) {
                this.elementObserver.detachListener(this.get(i));
            }
        }
        if (this.hasListeners()) {
            this.beginChange();
            this.nextRemove(0, (List)((Object)this));
        }
        this.backingList.clear();
        ++this.modCount;
        if (this.hasListeners()) {
            this.endChange();
        }
    }

    public void remove(int fromIndex, int toIndex) {
        Objects.checkFromToIndex(fromIndex, toIndex, this.size());
        this.beginChange();
        for (int i = fromIndex; i < toIndex; ++i) {
            this.remove(fromIndex);
        }
        this.endChange();
    }

    public boolean removeAll(Collection<?> c) {
        if (c.isEmpty() || this.backingList.isEmpty()) {
            return false;
        }
        this.beginChange();
        BitSet bs = new BitSet(c.size());
        for (int i = 0; i < this.size(); ++i) {
            if (!c.contains(this.get(i))) continue;
            bs.set(i);
        }
        if (!bs.isEmpty()) {
            int cur = this.size();
            while ((cur = bs.previousSetBit(cur - 1)) >= 0) {
                this.remove(cur);
            }
        }
        this.endChange();
        return !bs.isEmpty();
    }

    public boolean retainAll(Collection<?> c) {
        if (c.isEmpty() && !this.backingList.isEmpty()) {
            this.clear();
            return true;
        }
        if (this.backingList.isEmpty()) {
            return false;
        }
        this.beginChange();
        BitSet bs = new BitSet(c.size());
        for (int i = 0; i < this.size(); ++i) {
            if (c.contains(this.get(i))) continue;
            bs.set(i);
        }
        if (!bs.isEmpty()) {
            int cur = this.size();
            while ((cur = bs.previousSetBit(cur - 1)) >= 0) {
                this.remove(cur);
            }
        }
        this.endChange();
        return !bs.isEmpty();
    }
}

