/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.shim.collections;

import atlantafx.base.shim.collections.NonIterableChange;
import atlantafx.base.shim.collections.ObservableListWrapper;
import java.util.List;
import java.util.ListIterator;
import javafx.collections.ObservableList;

public class ReorderableList<E>
extends ObservableListWrapper<E> {
    private final List<E> backingList;

    public ReorderableList(List<E> backingList) {
        super(backingList);
        if (backingList instanceof ObservableList) {
            throw new IllegalArgumentException("backingList must not be an observable list");
        }
        this.backingList = backingList;
    }

    public void reorder(E from, E to) {
        if (from == to) {
            return;
        }
        this.reorder(this.backingList.indexOf(from), this.backingList.indexOf(to));
    }

    public void reorder(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex < 0 || fromIndex == toIndex) {
            return;
        }
        Object[] arr = this.backingList.toArray(new Object[this.backingList.size()]);
        int direction = (toIndex - fromIndex) / Math.abs(toIndex - fromIndex);
        for (int i = fromIndex; i != toIndex; i += direction) {
            arr[i] = arr[i + direction];
        }
        arr[toIndex] = this.backingList.get(fromIndex);
        ListIterator<Object> iterator = this.backingList.listIterator();
        for (int i = 0; i < this.backingList.size(); ++i) {
            iterator.next();
            iterator.set(arr[i]);
        }
        int permSize = Math.abs(toIndex - fromIndex) + 1;
        int[] perm = new int[permSize];
        int permFrom = direction > 0 ? fromIndex : toIndex;
        int permTo = direction < 0 ? fromIndex : toIndex;
        for (int i = 0; i < permSize; ++i) {
            perm[i] = i + permFrom;
        }
        this.fireChange(new NonIterableChange.SimplePermutationChange(permFrom, permTo + 1, perm, this));
    }
}

