/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.shim.event;

import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;

public final class CompositeEventHandler<T extends Event> {
    private EventProcessorRecord<T> firstRecord;
    private EventProcessorRecord<T> lastRecord;
    private EventHandler<? super T> eventHandler;

    public void setEventHandler(EventHandler<? super T> eventHandler) {
        this.eventHandler = eventHandler;
    }

    public EventHandler<? super T> getEventHandler() {
        return this.eventHandler;
    }

    public void addEventHandler(EventHandler<? super T> eventHandler) {
        if (this.find(eventHandler, false) == null) {
            this.append(this.lastRecord, this.createEventHandlerRecord(eventHandler));
        }
    }

    public void removeEventHandler(EventHandler<? super T> eventHandler) {
        EventProcessorRecord<? super T> record = this.find(eventHandler, false);
        if (record != null) {
            this.remove(record);
        }
    }

    public void addEventFilter(EventHandler<? super T> eventFilter) {
        if (this.find(eventFilter, true) == null) {
            this.append(this.lastRecord, this.createEventFilterRecord(eventFilter));
        }
    }

    public void removeEventFilter(EventHandler<? super T> eventFilter) {
        EventProcessorRecord<? super T> record = this.find(eventFilter, true);
        if (record != null) {
            this.remove(record);
        }
    }

    public void dispatchBubblingEvent(Event event) {
        Event specificEvent = event;
        EventProcessorRecord<Event> record = this.firstRecord;
        while (record != null) {
            if (record.isDisconnected()) {
                this.remove(record);
            } else {
                record.handleBubblingEvent(specificEvent);
            }
            record = record.nextRecord;
        }
        if (this.eventHandler != null) {
            this.eventHandler.handle(specificEvent);
        }
    }

    public void dispatchCapturingEvent(Event event) {
        Event specificEvent = event;
        EventProcessorRecord<Event> record = this.firstRecord;
        while (record != null) {
            if (record.isDisconnected()) {
                this.remove(record);
            } else {
                record.handleCapturingEvent(specificEvent);
            }
            record = record.nextRecord;
        }
    }

    public boolean hasFilter() {
        return this.find(true);
    }

    public boolean hasHandler() {
        if (this.getEventHandler() != null) {
            return true;
        }
        return this.find(false);
    }

    boolean containsHandler(EventHandler<? super T> eventHandler) {
        return this.find(eventHandler, false) != null;
    }

    boolean containsFilter(EventHandler<? super T> eventFilter) {
        return this.find(eventFilter, true) != null;
    }

    private EventProcessorRecord<T> createEventHandlerRecord(EventHandler<? super T> eventHandler) {
        return eventHandler instanceof WeakEventHandler ? new WeakEventHandlerRecord((WeakEventHandler)eventHandler) : new NormalEventHandlerRecord<T>(eventHandler);
    }

    private EventProcessorRecord<T> createEventFilterRecord(EventHandler<? super T> eventFilter) {
        return eventFilter instanceof WeakEventHandler ? new WeakEventFilterRecord((WeakEventHandler)eventFilter) : new NormalEventFilterRecord<T>(eventFilter);
    }

    private void remove(EventProcessorRecord<T> record) {
        EventProcessorRecord prevRecord = record.prevRecord;
        EventProcessorRecord nextRecord = record.nextRecord;
        if (prevRecord != null) {
            prevRecord.nextRecord = nextRecord;
        } else {
            this.firstRecord = nextRecord;
        }
        if (nextRecord != null) {
            nextRecord.prevRecord = prevRecord;
        } else {
            this.lastRecord = prevRecord;
        }
    }

    private void append(EventProcessorRecord<T> prevRecord, EventProcessorRecord<T> newRecord) {
        EventProcessorRecord nextRecord;
        if (prevRecord != null) {
            nextRecord = prevRecord.nextRecord;
            prevRecord.nextRecord = newRecord;
        } else {
            nextRecord = this.firstRecord;
            this.firstRecord = newRecord;
        }
        if (nextRecord != null) {
            nextRecord.prevRecord = newRecord;
        } else {
            this.lastRecord = newRecord;
        }
        newRecord.prevRecord = prevRecord;
        newRecord.nextRecord = nextRecord;
    }

    private EventProcessorRecord<T> find(EventHandler<? super T> eventProcessor, boolean isFilter) {
        EventProcessorRecord<? super T> record = this.firstRecord;
        while (record != null) {
            if (record.isDisconnected()) {
                this.remove(record);
            } else if (record.stores(eventProcessor, isFilter)) {
                return record;
            }
            record = record.nextRecord;
        }
        return null;
    }

    private boolean find(boolean isFilter) {
        EventProcessorRecord<T> record = this.firstRecord;
        while (record != null) {
            if (record.isDisconnected()) {
                this.remove(record);
            } else if (isFilter == record.isFilter()) {
                return true;
            }
            record = record.nextRecord;
        }
        return false;
    }

    private static abstract class EventProcessorRecord<T extends Event> {
        private EventProcessorRecord<T> nextRecord;
        private EventProcessorRecord<T> prevRecord;

        private EventProcessorRecord() {
        }

        public abstract boolean stores(EventHandler<? super T> var1, boolean var2);

        public abstract boolean isFilter();

        public abstract void handleBubblingEvent(T var1);

        public abstract void handleCapturingEvent(T var1);

        public abstract boolean isDisconnected();
    }

    private static final class WeakEventHandlerRecord<T extends Event>
    extends EventProcessorRecord<T> {
        private final WeakEventHandler<? super T> weakEventHandler;

        public WeakEventHandlerRecord(WeakEventHandler<? super T> weakEventHandler) {
            this.weakEventHandler = weakEventHandler;
        }

        @Override
        public boolean stores(EventHandler<? super T> eventProcessor, boolean isFilter) {
            return isFilter == this.isFilter() && this.weakEventHandler == eventProcessor;
        }

        @Override
        public boolean isFilter() {
            return false;
        }

        @Override
        public void handleBubblingEvent(T event) {
            this.weakEventHandler.handle(event);
        }

        @Override
        public void handleCapturingEvent(T event) {
        }

        @Override
        public boolean isDisconnected() {
            return this.weakEventHandler.wasGarbageCollected();
        }
    }

    private static final class NormalEventHandlerRecord<T extends Event>
    extends EventProcessorRecord<T> {
        private final EventHandler<? super T> eventHandler;

        public NormalEventHandlerRecord(EventHandler<? super T> eventHandler) {
            this.eventHandler = eventHandler;
        }

        @Override
        public boolean stores(EventHandler<? super T> eventProcessor, boolean isFilter) {
            return isFilter == this.isFilter() && this.eventHandler == eventProcessor;
        }

        @Override
        public boolean isFilter() {
            return false;
        }

        @Override
        public void handleBubblingEvent(T event) {
            this.eventHandler.handle(event);
        }

        @Override
        public void handleCapturingEvent(T event) {
        }

        @Override
        public boolean isDisconnected() {
            return false;
        }
    }

    private static final class WeakEventFilterRecord<T extends Event>
    extends EventProcessorRecord<T> {
        private final WeakEventHandler<? super T> weakEventFilter;

        public WeakEventFilterRecord(WeakEventHandler<? super T> weakEventFilter) {
            this.weakEventFilter = weakEventFilter;
        }

        @Override
        public boolean stores(EventHandler<? super T> eventProcessor, boolean isFilter) {
            return isFilter == this.isFilter() && this.weakEventFilter == eventProcessor;
        }

        @Override
        public boolean isFilter() {
            return true;
        }

        @Override
        public void handleBubblingEvent(T event) {
        }

        @Override
        public void handleCapturingEvent(T event) {
            this.weakEventFilter.handle(event);
        }

        @Override
        public boolean isDisconnected() {
            return this.weakEventFilter.wasGarbageCollected();
        }
    }

    private static final class NormalEventFilterRecord<T extends Event>
    extends EventProcessorRecord<T> {
        private final EventHandler<? super T> eventFilter;

        public NormalEventFilterRecord(EventHandler<? super T> eventFilter) {
            this.eventFilter = eventFilter;
        }

        @Override
        public boolean stores(EventHandler<? super T> eventProcessor, boolean isFilter) {
            return isFilter == this.isFilter() && this.eventFilter == eventProcessor;
        }

        @Override
        public boolean isFilter() {
            return true;
        }

        @Override
        public void handleBubblingEvent(T event) {
        }

        @Override
        public void handleCapturingEvent(T event) {
            this.eventFilter.handle(event);
        }

        @Override
        public boolean isDisconnected() {
            return false;
        }
    }
}

