/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.theme;

import org.jetbrains.annotations.Nullable;

public interface Theme {
    public String getName();

    public String getUserAgentStylesheet();

    @Nullable
    public String getUserAgentStylesheetBSS();

    public boolean isDarkMode();

    public static Theme of(final String name, final String userAgentStylesheet, final boolean darkMode) {
        if (name == null) {
            throw new NullPointerException("Name cannot be null!");
        }
        if (userAgentStylesheet == null) {
            throw new NullPointerException("User agent stylesheet cannot be null!");
        }
        return new Theme(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getUserAgentStylesheet() {
                return userAgentStylesheet;
            }

            @Override
            @Nullable
            public String getUserAgentStylesheetBSS() {
                return null;
            }

            @Override
            public boolean isDarkMode() {
                return darkMode;
            }
        };
    }

    default public boolean isDefault() {
        return "MODENA".equals(this.getUserAgentStylesheet()) || "CASPIAN".equals(this.getUserAgentStylesheet());
    }
}

