/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.util;

import atlantafx.base.util.BBCodeHandler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javafx.geometry.Pos;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;
import org.jetbrains.annotations.Nullable;

public class BBCodeParser {
    public static final Set<String> RESERVED_TAGS = Set.of("abbr", "align", "b", "caption", "center", "code", "color", "email", "heading", "font", "hr", "i", "indent", "label", "left", "li", "ol", "right", "s", "size", "small", "span", "style", "sub", "sup", "u", "ul", "url", "alert", "em", "fieldset", "h1", "h2", "h3", "h4", "icon", "img", "info", "kbd", "list", "media", "plain", "pre", "quote", "spoiler", "stop", "table", "tooltip", "td", "th", "tr", "warning");
    private final String input;
    private final BBCodeHandler handler;
    private final Set<String> processedTags;
    private final Deque<String> openTags = new ArrayDeque<String>();
    private int offset = 0;
    private int lastClosingPos = 0;

    public BBCodeParser(String input, BBCodeHandler handler) {
        this(input, handler, RESERVED_TAGS);
    }

    public BBCodeParser(String input, BBCodeHandler handler, @Nullable Set<String> tags) {
        this.input = Objects.requireNonNull(input, "Input can't be null.");
        this.handler = Objects.requireNonNull(handler, "Handler can't be null.");
        this.processedTags = Objects.requireNonNullElse(tags, RESERVED_TAGS);
    }

    public void parse() {
        this.handler.startDocument(this.input.toCharArray());
        while (this.offset < this.input.length()) {
            if (this.input.charAt(this.offset) == '[') {
                int openBracketPos = this.offset;
                int closeBracketPos = this.input.indexOf(93, this.offset);
                if (closeBracketPos == -1) {
                    ++this.offset;
                    continue;
                }
                int tagLength = closeBracketPos - openBracketPos + 1;
                if (tagLength == 2) {
                    ++this.offset;
                    continue;
                }
                if (this.input.charAt(openBracketPos + 1) != '/') {
                    boolean selfClose;
                    boolean isKnownTag;
                    if (this.openTags.isEmpty()) {
                        this.handleCharacters(this.lastClosingPos > 0 ? this.lastClosingPos + 1 : 0, this.lastClosingPos > 0 ? this.offset - this.lastClosingPos - 1 : this.offset);
                    }
                    if (!(isKnownTag = this.handleStartTag(openBracketPos, tagLength, selfClose = this.input.charAt(closeBracketPos - 1) == '/')) && this.openTags.isEmpty()) {
                        this.handleCharacters(openBracketPos, tagLength);
                        this.offset += tagLength;
                        this.lastClosingPos = closeBracketPos + 1;
                        continue;
                    }
                    if (selfClose) {
                        this.lastClosingPos = closeBracketPos;
                    }
                } else {
                    boolean isKnownTag = this.handleEndTag(openBracketPos, tagLength);
                    if (!isKnownTag && this.openTags.isEmpty()) {
                        this.handleCharacters(this.lastClosingPos, closeBracketPos - this.lastClosingPos + 1);
                    }
                    this.lastClosingPos = closeBracketPos;
                }
                this.offset = closeBracketPos + 1;
                continue;
            }
            ++this.offset;
        }
        if (!this.openTags.isEmpty()) {
            throw new IllegalStateException("Invalid BBCode: Opening tags without closing tags: " + String.valueOf(this.openTags));
        }
        if (this.lastClosingPos < this.input.length()) {
            this.handleCharacters(this.lastClosingPos > 0 ? this.lastClosingPos + 1 : this.lastClosingPos, this.lastClosingPos > 0 ? this.input.length() - this.lastClosingPos - 1 : this.input.length());
        }
        this.handler.endDocument();
    }

    public static TextFlow createFormattedText(String input) {
        return BBCodeParser.createLayout(input, new TextFlow());
    }

    public static VBox createLayout(String input) {
        VBox b = new VBox(10.0);
        b.setAlignment(Pos.TOP_LEFT);
        return BBCodeParser.createLayout(input, b);
    }

    public static <T extends Pane> T createLayout(String input, T container) {
        BBCodeHandler.Default<T> handler = new BBCodeHandler.Default<T>(container);
        BBCodeParser parser = new BBCodeParser(input, handler);
        parser.parse();
        return container;
    }

    protected boolean handleStartTag(int start, int length, boolean selfClose) {
        List<String> tokens = this.splitBySpace(this.input, start + 1, !selfClose ? length - 1 : length - 2);
        String name = tokens.get(0).toLowerCase();
        HashMap<String, String> params = null;
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            int separatorPos = token.indexOf("=");
            if (separatorPos < 0) continue;
            String key = token.substring(0, separatorPos).toLowerCase();
            String value = token.substring(separatorPos + 1);
            if (params == null) {
                params = new HashMap<String, String>();
            }
            if (i == 0) {
                name = key;
            }
            params.put(key, value);
        }
        if (!this.processedTags.contains(name)) {
            return false;
        }
        this.handler.startTag(name, params, start, length);
        if (!selfClose) {
            this.openTags.push(name);
        }
        return true;
    }

    protected boolean handleEndTag(int start, int length) {
        String name = this.input.substring(start + 2, start + length - 1).toLowerCase();
        if (!this.processedTags.contains(name)) {
            return false;
        }
        if (this.openTags.isEmpty()) {
            throw new IllegalStateException("Invalid BBCode: Closing tag without corresponding opening tag: '" + name + "'");
        }
        String lastTag = this.openTags.pop();
        if (!lastTag.equals(name)) {
            throw new IllegalStateException("Invalid BBCode: Closing tag '" + name + "' does not match opening tag '" + lastTag + "'");
        }
        this.handler.endTag(name, start, length);
        return true;
    }

    protected void handleCharacters(int start, int length) {
        this.handler.characters(start, length);
    }

    protected List<String> splitBySpace(String str, int start, int length) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean insideQuotes = false;
        for (int i = start; i < start + length - 1; ++i) {
            char ch = str.charAt(i);
            if (ch == ' ' && !insideQuotes) {
                tokens.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                insideQuotes = !insideQuotes;
                continue;
            }
            sb.append(ch);
        }
        tokens.add(sb.toString());
        return tokens;
    }
}

