/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.util;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Function;
import javafx.beans.WeakListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.jetbrains.annotations.Nullable;

public final class Bindings {
    public static <T, R> void bindContent(List<R> targetList, ObservableList<? extends T> sourceList, Function<T, R> mapper) {
        Bindings.checkParameters(targetList, sourceList);
        ListContentBinding<T, R> contentBinding = new ListContentBinding<T, R>(targetList, mapper);
        if (targetList instanceof ObservableList) {
            ObservableList observableList = (ObservableList)targetList;
            observableList.setAll(Bindings.map(sourceList, mapper));
        } else {
            targetList.clear();
            targetList.addAll(sourceList.stream().map(mapper).toList());
        }
        sourceList.removeListener(contentBinding);
        sourceList.addListener(contentBinding);
    }

    private static void checkParameters(@Nullable Object property1, @Nullable Object property2) {
        if (property1 == null || property2 == null) {
            throw new NullPointerException("Both parameters must be specified");
        }
        if (property1 == property2) {
            throw new IllegalArgumentException("Cannot bind object to itself");
        }
    }

    private static <T, R> List<R> map(List<? extends T> list, Function<T, R> mapper) {
        return list.stream().map(mapper).toList();
    }

    private static class ListContentBinding<T, R>
    implements ListChangeListener<T>,
    WeakListener {
        protected final WeakReference<List<R>> listRef;
        protected final Function<T, R> mapper;

        public ListContentBinding(List<R> list, Function<T, R> mapper) {
            this.listRef = new WeakReference<List<R>>(list);
            this.mapper = mapper;
        }

        public void onChanged(ListChangeListener.Change<? extends T> change) {
            List list = (List)this.listRef.get();
            if (list == null) {
                change.getList().removeListener((ListChangeListener)this);
            } else {
                while (change.next()) {
                    if (change.wasPermutated()) {
                        list.subList(change.getFrom(), change.getTo()).clear();
                        list.addAll(change.getFrom(), Bindings.map(change.getList().subList(change.getFrom(), change.getTo()), this.mapper));
                        continue;
                    }
                    if (change.wasRemoved()) {
                        list.subList(change.getFrom(), change.getFrom() + change.getRemovedSize()).clear();
                    }
                    if (!change.wasAdded()) continue;
                    list.addAll(change.getFrom(), Bindings.map(change.getAddedSubList(), this.mapper));
                }
            }
        }

        public boolean wasGarbageCollected() {
            return this.listRef.get() == null;
        }

        public int hashCode() {
            List list = (List)this.listRef.get();
            return list == null ? 0 : list.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            List ourList = (List)this.listRef.get();
            if (ourList == null) {
                return false;
            }
            if (obj instanceof ListContentBinding) {
                ListContentBinding other = (ListContentBinding)obj;
                List theirList = (List)other.listRef.get();
                return ourList == theirList;
            }
            return false;
        }
    }
}

