/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.util;

import atlantafx.base.util.MaskChar;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public final class SimpleMaskChar
implements MaskChar {
    private final Predicate<Character> matchExpr;
    private final UnaryOperator<Character> transform;
    private final char placeholder;
    private final boolean fixed;

    public SimpleMaskChar(Predicate<Character> matchExpr) {
        this(matchExpr, UnaryOperator.identity(), '_', false);
    }

    public SimpleMaskChar(Predicate<Character> matchExpr, UnaryOperator<Character> transform) {
        this(matchExpr, transform, '_', false);
    }

    public SimpleMaskChar(Predicate<Character> matchExpr, UnaryOperator<Character> transform, char placeholder) {
        this(matchExpr, transform, placeholder, false);
    }

    public SimpleMaskChar(Predicate<Character> matchExpr, UnaryOperator<Character> transform, char placeholder, boolean fixed) {
        this.matchExpr = Objects.requireNonNull(matchExpr);
        this.transform = Objects.requireNonNull(transform);
        this.placeholder = placeholder;
        this.fixed = fixed;
    }

    @Override
    public boolean isAllowed(char ch) {
        return this.matchExpr.test(Character.valueOf(ch));
    }

    @Override
    public char transform(char ch) {
        return ((Character)this.transform.apply(Character.valueOf(ch))).charValue();
    }

    @Override
    public char getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    public static SimpleMaskChar fixed(char ch) {
        return new SimpleMaskChar(c -> c.charValue() == ch, UnaryOperator.identity(), ch, true);
    }
}

