/*
 * Decompiled with CFR 0.152.
 */
package backbonefx.di;

import backbonefx.di.FeatherException;
import backbonefx.di.Initializable;
import backbonefx.di.Key;
import backbonefx.di.Provides;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Feather {
    private final Map<Key<?>, Provider<?>> providers = new ConcurrentHashMap();
    private final Map<Key<?>, Object> singletons = new ConcurrentHashMap();
    private final Map<Class<?>, Object[][]> injectFields = new ConcurrentHashMap(0);

    public static Feather with(Object ... modules) {
        return new Feather(Arrays.asList(modules));
    }

    public static Feather with(Iterable<?> modules) {
        return new Feather(modules);
    }

    private Feather(Iterable<?> modules) {
        this.providers.put(Key.of(Feather.class), () -> this);
        for (Object module : modules) {
            if (module instanceof Class) {
                Class c = (Class)module;
                throw new FeatherException(String.format("%s provided as class instead of an instance.", c.getName()));
            }
            for (Method providerMethod : Feather.providers(module.getClass())) {
                this.providerMethod(module, providerMethod);
            }
        }
    }

    public <T> T instance(Class<T> type) {
        return (T)this.provider(Key.of(type), null).get();
    }

    public <T> T instance(Key<T> key) {
        return (T)this.provider(key, null).get();
    }

    public <T> Provider<T> provider(Class<T> type) {
        return this.provider(Key.of(type), null);
    }

    public <T> Provider<T> provider(Key<T> key) {
        return this.provider(key, null);
    }

    public void injectFields(Object target) {
        if (!this.injectFields.containsKey(target.getClass())) {
            this.injectFields.put(target.getClass(), Feather.injectFields(target.getClass()));
        }
        for (Object[] f : this.injectFields.get(target.getClass())) {
            Field field = (Field)f[0];
            Key key = (Key)f[2];
            try {
                field.set(target, (Boolean)f[1] != false ? this.provider(key) : this.instance(key));
            }
            catch (Exception e) {
                throw new FeatherException(String.format("Can't inject field %s in %s", field.getName(), target.getClass().getName()), e);
            }
        }
    }

    private <T> Provider<T> provider(Key<T> key, Set<Key<?>> chain) {
        if (!this.providers.containsKey(key)) {
            Constructor<?> constructor = Feather.constructor(key);
            Provider<?>[] paramProviders = this.paramProviders(key, constructor.getParameterTypes(), constructor.getGenericParameterTypes(), constructor.getParameterAnnotations(), chain);
            this.providers.put(key, this.singletonProvider(key, key.type.getAnnotation(Singleton.class), () -> {
                try {
                    Object o = constructor.newInstance(Feather.params(paramProviders));
                    if (o instanceof Initializable) {
                        Initializable initializable = (Initializable)o;
                        initializable.init();
                    }
                    return o;
                }
                catch (Exception e) {
                    throw new FeatherException(String.format("Can't instantiate %s", key), e);
                }
            }));
        }
        return this.providers.get(key);
    }

    private void providerMethod(Object module, Method m) {
        Key<?> key = Key.of(m.getReturnType(), Feather.qualifier(m.getAnnotations()));
        if (this.providers.containsKey(key)) {
            throw new FeatherException(String.format("%s has multiple providers, module %s", key, module.getClass()));
        }
        Singleton singleton = m.getAnnotation(Singleton.class) != null ? m.getAnnotation(Singleton.class) : m.getReturnType().getAnnotation(Singleton.class);
        Provider<?>[] paramProviders = this.paramProviders(key, m.getParameterTypes(), m.getGenericParameterTypes(), m.getParameterAnnotations(), Collections.singleton(key));
        this.providers.put(key, this.singletonProvider(key, singleton, () -> {
            try {
                return m.invoke(module, Feather.params(paramProviders));
            }
            catch (Exception e) {
                throw new FeatherException(String.format("Can't instantiate %s with provider", key), e);
            }
        }));
    }

    private <T> Provider<T> singletonProvider(Key<?> key, Singleton singleton, Provider<T> provider) {
        return singleton != null ? () -> {
            if (!this.singletons.containsKey(key)) {
                Map<Key<?>, Object> map = this.singletons;
                synchronized (map) {
                    if (!this.singletons.containsKey(key)) {
                        this.singletons.put(key, provider.get());
                    }
                }
            }
            return this.singletons.get(key);
        } : provider;
    }

    private Provider<?>[] paramProviders(Key<?> key, Class<?>[] parameterClasses, Type[] parameterTypes, Annotation[][] annotations, Set<Key<?>> chain) {
        Provider[] providers = new Provider[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Key<Object> newKey;
            Class providerType;
            Class<?> parameterClass = parameterClasses[i];
            Annotation qualifier = Feather.qualifier(annotations[i]);
            Class clazz = providerType = Provider.class.equals(parameterClass) ? (Class)((ParameterizedType)parameterTypes[i]).getActualTypeArguments()[0] : null;
            if (providerType == null) {
                newKey = Key.of(parameterClass, qualifier);
                Set<Key<?>> newChain = Feather.append(chain, key);
                if (newChain.contains(newKey)) {
                    throw new FeatherException(String.format("Circular dependency: %s", Feather.chain(newChain, newKey)));
                }
                providers[i] = () -> this.provider(newKey, newChain).get();
                continue;
            }
            newKey = Key.of(providerType, qualifier);
            providers[i] = () -> this.provider(newKey, null);
        }
        return providers;
    }

    private static Object[] params(Provider<?>[] paramProviders) {
        Object[] params = new Object[paramProviders.length];
        for (int i = 0; i < paramProviders.length; ++i) {
            params[i] = paramProviders[i].get();
        }
        return params;
    }

    private static Set<Key<?>> append(Set<Key<?>> set, Key<?> newKey) {
        if (set != null && !set.isEmpty()) {
            LinkedHashSet appended = new LinkedHashSet(set);
            appended.add(newKey);
            return appended;
        }
        return Collections.singleton(newKey);
    }

    private static Object[][] injectFields(Class<?> target) {
        Set<Field> fields = Feather.fields(target);
        Object[][] fs = new Object[fields.size()][];
        int i = 0;
        for (Field f : fields) {
            Class providerType = f.getType().equals(Provider.class) ? (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0] : null;
            Class keyType = providerType != null ? providerType : f.getType();
            fs[i++] = new Object[]{f, providerType != null, Key.of(keyType, Feather.qualifier(f.getAnnotations()))};
        }
        return fs;
    }

    private static Set<Field> fields(Class<?> type) {
        Class<?> current = type;
        HashSet<Field> fields = new HashSet<Field>();
        while (!current.equals(Object.class)) {
            for (Field field : current.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Inject.class)) continue;
                field.setAccessible(true);
                fields.add(field);
            }
            current = current.getSuperclass();
        }
        return fields;
    }

    private static String chain(Set<Key<?>> chain, Key<?> lastKey) {
        StringBuilder chainString = new StringBuilder();
        for (Key<?> key : chain) {
            chainString.append(key.toString()).append(" -> ");
        }
        return chainString.append(lastKey.toString()).toString();
    }

    private static Constructor<?> constructor(Key<?> key) {
        Constructor<?> constructor;
        Constructor<?> inject = null;
        Constructor<?> noarg = null;
        for (Constructor<?> c : key.type.getDeclaredConstructors()) {
            if (c.isAnnotationPresent(Inject.class)) {
                if (inject == null) {
                    inject = c;
                    continue;
                }
                throw new FeatherException(String.format("%s has multiple @Inject constructors", key.type));
            }
            if (c.getParameterTypes().length != 0) continue;
            noarg = c;
        }
        Constructor<?> constructor2 = constructor = inject != null ? inject : noarg;
        if (constructor != null) {
            constructor.setAccessible(true);
            return constructor;
        }
        throw new FeatherException(String.format("%s doesn't have an @Inject or no-arg constructor, or a module provider", key.type.getName()));
    }

    private static Set<Method> providers(Class<?> type) {
        Class<?> current = type;
        HashSet<Method> providers = new HashSet<Method>();
        while (!current.equals(Object.class)) {
            for (Method method : current.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Provides.class) || !type.equals(current) && Feather.providerInSubClass(method, providers)) continue;
                method.setAccessible(true);
                providers.add(method);
            }
            current = current.getSuperclass();
        }
        return providers;
    }

    private static Annotation qualifier(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            return annotation;
        }
        return null;
    }

    private static boolean providerInSubClass(Method method, Set<Method> discoveredMethods) {
        for (Method discovered : discoveredMethods) {
            if (!discovered.getName().equals(method.getName()) || !Arrays.equals(method.getParameterTypes(), discovered.getParameterTypes())) continue;
            return true;
        }
        return false;
    }
}

