/*
 * Decompiled with CFR 0.152.
 */
package backbonefx.event;

import backbonefx.event.Event;
import backbonefx.event.EventSource;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEvent
implements Event {
    protected final UUID id = UUID.randomUUID();
    protected final EventSource source;

    protected AbstractEvent() {
        this(null);
    }

    protected AbstractEvent(EventSource source) {
        this.source = source;
    }

    public UUID getId() {
        return this.id;
    }

    @Nullable
    public EventSource getSource() {
        return this.source;
    }

    public boolean isSentBy(EventSource source) {
        return Objects.equals(this.getSource(), source);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractEvent event = (AbstractEvent)o;
        return this.id.equals(event.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Event{id=" + String.valueOf(this.id) + ", source=" + String.valueOf(this.source) + "}";
    }
}

