/*
 * Decompiled with CFR 0.152.
 */
package backbonefx.event;

import backbonefx.event.Event;
import backbonefx.event.EventBus;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;

public final class DefaultEventBus
implements EventBus {
    private final Map<Class<?>, Set<Consumer<?>>> subscribers = new ConcurrentHashMap();

    public <E extends Event> void subscribe(Class<? extends E> eventType, Consumer<E> subscriber) {
        Objects.requireNonNull(eventType, "Event type must be specified.");
        Objects.requireNonNull(subscriber, "Subscriber must not be null.");
        Set<Consumer<?>> eventSubscribers = this.getOrCreateSubscribers(eventType);
        eventSubscribers.add(subscriber);
    }

    public <E extends Event> void unsubscribe(Consumer<E> subscriber) {
        if (subscriber == null) {
            return;
        }
        this.subscribers.values().forEach(eventSubscribers -> eventSubscribers.remove(subscriber));
    }

    public <E extends Event> void unsubscribe(Class<? extends E> eventType, Consumer<E> subscriber) {
        Objects.requireNonNull(eventType, "Event type must be specified.");
        Objects.requireNonNull(subscriber, "Subscriber must not be null.");
        this.subscribers.keySet().stream().filter(eventType::isAssignableFrom).map(this.subscribers::get).forEach(eventSubscribers -> eventSubscribers.remove(subscriber));
    }

    public <E extends Event> void publish(E event) {
        Objects.requireNonNull(event, "Event must not be null.");
        Class<?> eventType = event.getClass();
        this.subscribers.keySet().stream().filter(type -> type.isAssignableFrom(eventType)).flatMap(type -> this.subscribers.get(type).stream()).forEach(subscriber -> this.publish(event, (Consumer)subscriber));
    }

    private <E> Set<Consumer<?>> getOrCreateSubscribers(Class<E> eventType) {
        Set<Consumer<?>> eventSubscribers = this.subscribers.get(eventType);
        if (eventSubscribers == null) {
            eventSubscribers = new CopyOnWriteArraySet();
            this.subscribers.put(eventType, eventSubscribers);
        }
        return eventSubscribers;
    }

    private <E extends Event> void publish(E event, Consumer<E> subscriber) {
        try {
            subscriber.accept(event);
        }
        catch (Exception e) {
            Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }
}

