/*
 * Decompiled with CFR 0.152.
 */
package backbonefx.mvvm;

import backbonefx.mvvm.BackgroundTask;
import backbonefx.mvvm.Command;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import org.jetbrains.annotations.Nullable;

public class BackgroundCommand<T, V>
implements Command<T> {
    protected final Supplier<BackgroundTask<T, V>> actionSupplier;
    protected final ObservableBooleanValue expression;
    protected final Executor executor;

    public BackgroundCommand(Supplier<BackgroundTask<T, V>> actionSupplier) {
        this(actionSupplier, null, null);
    }

    public BackgroundCommand(Supplier<BackgroundTask<T, V>> actionSupplier, @Nullable ObservableBooleanValue expression) {
        this(actionSupplier, expression, null);
    }

    public BackgroundCommand(Supplier<BackgroundTask<T, V>> actionSupplier, @Nullable ObservableBooleanValue expression, @Nullable Executor executor) {
        this.actionSupplier = Objects.requireNonNull(actionSupplier, "Action must not be null.");
        this.expression = (ObservableBooleanValue)Objects.requireNonNullElse(expression, new SimpleBooleanProperty((Object)this, "expression", true));
        this.executor = executor;
    }

    @Override
    public boolean isExecutable() {
        return this.expression.get();
    }

    public ObservableBooleanValue executableProperty() {
        return this.expression;
    }

    @Override
    public void execute(@Nullable T arg) {
        if (this.isExecutable()) {
            this.runTask(arg);
        }
    }

    protected void runTask(@Nullable T arg) {
        BackgroundTask<T, V> task = this.actionSupplier.get();
        task.accept(arg);
        if (this.executor != null) {
            this.executor.execute((Runnable)((Object)task));
        } else {
            new Thread((Runnable)((Object)task)).start();
        }
    }
}

