/*
 * Decompiled with CFR 0.152.
 */
package backbonefx.mvvm;

import backbonefx.mvvm.Command;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import org.jetbrains.annotations.Nullable;

public class ConsumerCommand<T>
implements Command<T>,
Consumer<T> {
    protected final Consumer<T> action;
    protected final ObservableBooleanValue expression;

    public ConsumerCommand(Consumer<T> action) {
        this(action, null);
    }

    public ConsumerCommand(Consumer<T> action, @Nullable ObservableBooleanValue expression) {
        this.action = Objects.requireNonNull(action, "Action must not be null.");
        this.expression = (ObservableBooleanValue)Objects.requireNonNullElse(expression, new SimpleBooleanProperty((Object)this, "expression", true));
    }

    @Override
    public final boolean isExecutable() {
        return this.expression.get();
    }

    public ObservableBooleanValue executableProperty() {
        return this.expression;
    }

    @Override
    public void execute(@Nullable T arg) {
        if (this.isExecutable()) {
            this.action.accept(arg);
        }
    }

    @Override
    public void accept(@Nullable T arg) {
        this.execute(arg);
    }
}

